"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
/**
 * Auto Scaling groups which are associated with load balancers utilize ELB health checks - (Control IDs: SC-5)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        //get all associated CLBs
        const classicLBs = monocdk_1.Stack.of(node).resolve(node.loadBalancerNames);
        //get all associated Application LBs, Gateway LBs, and Network LBs
        const otherLBs = monocdk_1.Stack.of(node).resolve(node.targetGroupArns);
        if ((otherLBs != undefined && otherLBs.length > 0) ||
            (classicLBs != undefined && classicLBs.length > 0)) {
            const healthCheckType = monocdk_1.Stack.of(node).resolve(node.healthCheckType);
            //Do we use ELB health checks?
            if (healthCheckType != undefined) {
                if (healthCheckType != 'ELB') {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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