"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_apigateway_1 = require("monocdk/aws-apigateway");
/**
 * API Gateway stages have logging enabled - (Control ID: 164.312(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_apigateway_1.CfnStage) {
        if (node.methodSettings == undefined) {
            return false;
        }
        const methodSettings = monocdk_1.Stack.of(node).resolve(node.methodSettings);
        let found = false;
        for (const setting of methodSettings) {
            const resolvedSetting = monocdk_1.Stack.of(node).resolve(setting);
            if ((resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.httpMethod) == '*' &&
                (resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.resourcePath) == '/*' &&
                ((resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.loggingLevel) == aws_apigateway_1.MethodLoggingLevel.ERROR ||
                    (resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.loggingLevel) == aws_apigateway_1.MethodLoggingLevel.INFO)) {
                found = true;
                break;
            }
        }
        if (!found) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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