"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cognito_1 = require("monocdk/aws-cognito");
/**
 * Cognito user pools have AdvancedSecurityMode set to ENFORCED
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cognito_1.CfnUserPool) {
        const userPoolAddOns = monocdk_1.Stack.of(node).resolve(node.userPoolAddOns);
        if (userPoolAddOns == undefined) {
            return false;
        }
        const advancedSecurityMode = monocdk_1.Stack.of(node).resolve(userPoolAddOns.advancedSecurityMode);
        if (advancedSecurityMode == undefined ||
            advancedSecurityMode != 'ENFORCED') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ09HMy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvc2VjdXJpdHlfYW5kX2NvbXBsaWFuY2UvQ09HMy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFDQUE0QztBQUM1QyxxREFBa0Q7QUFFbEQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWdCO0lBQ3ZDLElBQUksSUFBSSxZQUFZLHlCQUFXLEVBQUU7UUFDL0IsTUFBTSxjQUFjLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ25FLElBQUksY0FBYyxJQUFJLFNBQVMsRUFBRTtZQUMvQixPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsTUFBTSxvQkFBb0IsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FDakQsY0FBYyxDQUFDLG9CQUFvQixDQUNwQyxDQUFDO1FBQ0YsSUFDRSxvQkFBb0IsSUFBSSxTQUFTO1lBQ2pDLG9CQUFvQixJQUFJLFVBQVUsRUFDbEM7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFqQkQsNEJBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBJQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuVXNlclBvb2wgfSBmcm9tICdtb25vY2RrL2F3cy1jb2duaXRvJztcblxuLyoqXG4gKiBDb2duaXRvIHVzZXIgcG9vbHMgaGF2ZSBBZHZhbmNlZFNlY3VyaXR5TW9kZSBzZXQgdG8gRU5GT1JDRURcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogSUNvbnN0cnVjdCk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmblVzZXJQb29sKSB7XG4gICAgY29uc3QgdXNlclBvb2xBZGRPbnMgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUudXNlclBvb2xBZGRPbnMpO1xuICAgIGlmICh1c2VyUG9vbEFkZE9ucyA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgY29uc3QgYWR2YW5jZWRTZWN1cml0eU1vZGUgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgdXNlclBvb2xBZGRPbnMuYWR2YW5jZWRTZWN1cml0eU1vZGUsXG4gICAgKTtcbiAgICBpZiAoXG4gICAgICBhZHZhbmNlZFNlY3VyaXR5TW9kZSA9PSB1bmRlZmluZWQgfHxcbiAgICAgIGFkdmFuY2VkU2VjdXJpdHlNb2RlICE9ICdFTkZPUkNFRCdcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=