# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pystrand', 'pystrand.loggers', 'pystrand.models', 'pystrand.operators']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.18.5,<2.0.0', 'pandas>=1.2.0,<2.0.0']

setup_kwargs = {
    'name': 'pystrand',
    'version': '0.1.0',
    'description': 'Python genetic algorithm package',
    'long_description': '# pystrand\n\n![build](https://github.com/jpodivin/pystrand/actions/workflows/build.yml/badge.svg)\n\n## Quickstart\n\nIn order to define a genetic algorithm you only need to determine\nhow should genotypes, or candidate solutions, look and which operators\nshould apply to them.\n\nThe rest is simply matter of providing training data.\n\nIn our case the data was generated by function `f(x) = 5 + 5x + 2x^2`.\n\n```\n   >>>x = [i for i in range(10)]\n   >>>y = [5 + (5*i) +(2*(i**2)) for i in x]\n```\n\nAfter importing the model class we define which values can genes take.\n```\n   >>>from pystrand.models.polymodels import PowerPolyModel\n   >>>domain = [i/10 for i in range(-100, 100)]\n```\n\nAt the model initialization we can provide constraints on operator behavior, population size\nand maximum allowed runtime. This is particulary useful if we are looking for approximate solution.\n\n```\n >>> model = PowerPolyModel(domain, population_size=500, max_iterations=1000, crossover_prob=0.5)\n```\n\nWe can also initialize the model with no constraints on the behavior of the algorithm, which will\nset parameters to pre-determined defaults.\nThe only required parameter is the domain of gene values.\n\n```\n >>> model = PowerPolyModel(domain)\n```\n\nModel is then fitted on provided data. \n```\n   >>>model.fit(x, y, verbose=0)\n   >>>model.solution\n   ... (1., Genotype([5., 5., 2., 0., 0., 0., 0., 0., 0., 0.]))\n```\n\n',
    'author': 'Jiri Podivin',
    'author_email': 'jpodivin@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
