# pystrand

![build](https://github.com/jpodivin/pystrand/actions/workflows/build.yml/badge.svg)

## Quickstart

In order to define a genetic algorithm you only need to determine
how should genotypes, or candidate solutions, look and which operators
should apply to them.

The rest is simply matter of providing training data.

In our case the data was generated by function `f(x) = 5 + 5x + 2x^2`.

```
   >>>x = [i for i in range(10)]
   >>>y = [5 + (5*i) +(2*(i**2)) for i in x]
```

After importing the model class we define which values can genes take.
```
   >>>from pystrand.models.polymodels import PowerPolyModel
   >>>domain = [i/10 for i in range(-100, 100)]
```

At the model initialization we can provide constraints on operator behavior, population size
and maximum allowed runtime. This is particulary useful if we are looking for approximate solution.

```
 >>> model = PowerPolyModel(domain, population_size=500, max_iterations=1000, crossover_prob=0.5)
```

We can also initialize the model with no constraints on the behavior of the algorithm, which will
set parameters to pre-determined defaults.
The only required parameter is the domain of gene values.

```
 >>> model = PowerPolyModel(domain)
```

Model is then fitted on provided data. 
```
   >>>model.fit(x, y, verbose=0)
   >>>model.solution
   ... (1., Genotype([5., 5., 2., 0., 0., 0., 0., 0., 0., 0.]))
```

