# coding: utf-8

"""
  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from .dimension_based_attribute import DimensionBasedAttribute  # noqa: F401,E501
from .single_boolean_valued_attribute import SingleBooleanValuedAttribute  # noqa: F401,E501
from .single_integer_valued_attribute import SingleIntegerValuedAttribute  # noqa: F401,E501
from .single_string_valued_attribute import SingleStringValuedAttribute  # noqa: F401,E501


class ProductInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'color': 'SingleStringValuedAttribute',
        'is_adult_product': 'SingleBooleanValuedAttribute',
        'item_dimensions': 'DimensionBasedAttribute',
        'release_date': 'SingleStringValuedAttribute',
        'size': 'SingleStringValuedAttribute',
        'unit_count': 'SingleIntegerValuedAttribute'
    }

    attribute_map = {
        'color': 'Color',
        'is_adult_product': 'IsAdultProduct',
        'item_dimensions': 'ItemDimensions',
        'release_date': 'ReleaseDate',
        'size': 'Size',
        'unit_count': 'UnitCount'
    }

    def __init__(self, color=None, is_adult_product=None, item_dimensions=None, release_date=None, size=None, unit_count=None):  # noqa: E501
        """ProductInfo - a model defined in Swagger"""  # noqa: E501

        self._color = None
        self._is_adult_product = None
        self._item_dimensions = None
        self._release_date = None
        self._size = None
        self._unit_count = None
        self.discriminator = None

        if color is not None:
            self.color = color
        if is_adult_product is not None:
            self.is_adult_product = is_adult_product
        if item_dimensions is not None:
            self.item_dimensions = item_dimensions
        if release_date is not None:
            self.release_date = release_date
        if size is not None:
            self.size = size
        if unit_count is not None:
            self.unit_count = unit_count

    @property
    def color(self):
        """Gets the color of this ProductInfo.  # noqa: E501


        :return: The color of this ProductInfo.  # noqa: E501
        :rtype: SingleStringValuedAttribute
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this ProductInfo.


        :param color: The color of this ProductInfo.  # noqa: E501
        :type: SingleStringValuedAttribute
        """

        self._color = color

    @property
    def is_adult_product(self):
        """Gets the is_adult_product of this ProductInfo.  # noqa: E501


        :return: The is_adult_product of this ProductInfo.  # noqa: E501
        :rtype: SingleBooleanValuedAttribute
        """
        return self._is_adult_product

    @is_adult_product.setter
    def is_adult_product(self, is_adult_product):
        """Sets the is_adult_product of this ProductInfo.


        :param is_adult_product: The is_adult_product of this ProductInfo.  # noqa: E501
        :type: SingleBooleanValuedAttribute
        """

        self._is_adult_product = is_adult_product

    @property
    def item_dimensions(self):
        """Gets the item_dimensions of this ProductInfo.  # noqa: E501


        :return: The item_dimensions of this ProductInfo.  # noqa: E501
        :rtype: DimensionBasedAttribute
        """
        return self._item_dimensions

    @item_dimensions.setter
    def item_dimensions(self, item_dimensions):
        """Sets the item_dimensions of this ProductInfo.


        :param item_dimensions: The item_dimensions of this ProductInfo.  # noqa: E501
        :type: DimensionBasedAttribute
        """

        self._item_dimensions = item_dimensions

    @property
    def release_date(self):
        """Gets the release_date of this ProductInfo.  # noqa: E501


        :return: The release_date of this ProductInfo.  # noqa: E501
        :rtype: SingleStringValuedAttribute
        """
        return self._release_date

    @release_date.setter
    def release_date(self, release_date):
        """Sets the release_date of this ProductInfo.


        :param release_date: The release_date of this ProductInfo.  # noqa: E501
        :type: SingleStringValuedAttribute
        """

        self._release_date = release_date

    @property
    def size(self):
        """Gets the size of this ProductInfo.  # noqa: E501


        :return: The size of this ProductInfo.  # noqa: E501
        :rtype: SingleStringValuedAttribute
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this ProductInfo.


        :param size: The size of this ProductInfo.  # noqa: E501
        :type: SingleStringValuedAttribute
        """

        self._size = size

    @property
    def unit_count(self):
        """Gets the unit_count of this ProductInfo.  # noqa: E501


        :return: The unit_count of this ProductInfo.  # noqa: E501
        :rtype: SingleIntegerValuedAttribute
        """
        return self._unit_count

    @unit_count.setter
    def unit_count(self, unit_count):
        """Sets the unit_count of this ProductInfo.


        :param unit_count: The unit_count of this ProductInfo.  # noqa: E501
        :type: SingleIntegerValuedAttribute
        """

        self._unit_count = unit_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProductInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProductInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
