# coding: utf-8

"""
 Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 A copy of the License is located at

     http://www.apache.org/licenses/LICENSE-2.0

 or in the "license" file accompanying this file. This file is distributed
 on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 express or implied. See the License for the specific language governing
 permissions and limitations under the License.
"""

"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from .by_line_info import ByLineInfo  # noqa: F401,E501
from .classifications import Classifications  # noqa: F401,E501
from .content_info import ContentInfo  # noqa: F401,E501
from .content_rating import ContentRating  # noqa: F401,E501
from .external_ids import ExternalIds  # noqa: F401,E501
from .manufacture_info import ManufactureInfo  # noqa: F401,E501
from .multi_valued_attribute import MultiValuedAttribute  # noqa: F401,E501
from .product_info import ProductInfo  # noqa: F401,E501
from .single_string_valued_attribute import SingleStringValuedAttribute  # noqa: F401,E501
from .technical_info import TechnicalInfo  # noqa: F401,E501
from .trade_in_info import TradeInInfo  # noqa: F401,E501


class ItemInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'by_line_info': 'ByLineInfo',
        'classifications': 'Classifications',
        'content_info': 'ContentInfo',
        'content_rating': 'ContentRating',
        'external_ids': 'ExternalIds',
        'features': 'MultiValuedAttribute',
        'manufacture_info': 'ManufactureInfo',
        'product_info': 'ProductInfo',
        'technical_info': 'TechnicalInfo',
        'title': 'SingleStringValuedAttribute',
        'trade_in_info': 'TradeInInfo'
    }

    attribute_map = {
        'by_line_info': 'ByLineInfo',
        'classifications': 'Classifications',
        'content_info': 'ContentInfo',
        'content_rating': 'ContentRating',
        'external_ids': 'ExternalIds',
        'features': 'Features',
        'manufacture_info': 'ManufactureInfo',
        'product_info': 'ProductInfo',
        'technical_info': 'TechnicalInfo',
        'title': 'Title',
        'trade_in_info': 'TradeInInfo'
    }

    def __init__(self, by_line_info=None, classifications=None, content_info=None, content_rating=None, external_ids=None, features=None, manufacture_info=None, product_info=None, technical_info=None, title=None, trade_in_info=None):  # noqa: E501
        """ItemInfo - a model defined in Swagger"""  # noqa: E501

        self._by_line_info = None
        self._classifications = None
        self._content_info = None
        self._content_rating = None
        self._external_ids = None
        self._features = None
        self._manufacture_info = None
        self._product_info = None
        self._technical_info = None
        self._title = None
        self._trade_in_info = None
        self.discriminator = None

        if by_line_info is not None:
            self.by_line_info = by_line_info
        if classifications is not None:
            self.classifications = classifications
        if content_info is not None:
            self.content_info = content_info
        if content_rating is not None:
            self.content_rating = content_rating
        if external_ids is not None:
            self.external_ids = external_ids
        if features is not None:
            self.features = features
        if manufacture_info is not None:
            self.manufacture_info = manufacture_info
        if product_info is not None:
            self.product_info = product_info
        if technical_info is not None:
            self.technical_info = technical_info
        if title is not None:
            self.title = title
        if trade_in_info is not None:
            self.trade_in_info = trade_in_info

    @property
    def by_line_info(self):
        """Gets the by_line_info of this ItemInfo.  # noqa: E501


        :return: The by_line_info of this ItemInfo.  # noqa: E501
        :rtype: ByLineInfo
        """
        return self._by_line_info

    @by_line_info.setter
    def by_line_info(self, by_line_info):
        """Sets the by_line_info of this ItemInfo.


        :param by_line_info: The by_line_info of this ItemInfo.  # noqa: E501
        :type: ByLineInfo
        """

        self._by_line_info = by_line_info

    @property
    def classifications(self):
        """Gets the classifications of this ItemInfo.  # noqa: E501


        :return: The classifications of this ItemInfo.  # noqa: E501
        :rtype: Classifications
        """
        return self._classifications

    @classifications.setter
    def classifications(self, classifications):
        """Sets the classifications of this ItemInfo.


        :param classifications: The classifications of this ItemInfo.  # noqa: E501
        :type: Classifications
        """

        self._classifications = classifications

    @property
    def content_info(self):
        """Gets the content_info of this ItemInfo.  # noqa: E501


        :return: The content_info of this ItemInfo.  # noqa: E501
        :rtype: ContentInfo
        """
        return self._content_info

    @content_info.setter
    def content_info(self, content_info):
        """Sets the content_info of this ItemInfo.


        :param content_info: The content_info of this ItemInfo.  # noqa: E501
        :type: ContentInfo
        """

        self._content_info = content_info

    @property
    def content_rating(self):
        """Gets the content_rating of this ItemInfo.  # noqa: E501


        :return: The content_rating of this ItemInfo.  # noqa: E501
        :rtype: ContentRating
        """
        return self._content_rating

    @content_rating.setter
    def content_rating(self, content_rating):
        """Sets the content_rating of this ItemInfo.


        :param content_rating: The content_rating of this ItemInfo.  # noqa: E501
        :type: ContentRating
        """

        self._content_rating = content_rating

    @property
    def external_ids(self):
        """Gets the external_ids of this ItemInfo.  # noqa: E501


        :return: The external_ids of this ItemInfo.  # noqa: E501
        :rtype: ExternalIds
        """
        return self._external_ids

    @external_ids.setter
    def external_ids(self, external_ids):
        """Sets the external_ids of this ItemInfo.


        :param external_ids: The external_ids of this ItemInfo.  # noqa: E501
        :type: ExternalIds
        """

        self._external_ids = external_ids

    @property
    def features(self):
        """Gets the features of this ItemInfo.  # noqa: E501


        :return: The features of this ItemInfo.  # noqa: E501
        :rtype: MultiValuedAttribute
        """
        return self._features

    @features.setter
    def features(self, features):
        """Sets the features of this ItemInfo.


        :param features: The features of this ItemInfo.  # noqa: E501
        :type: MultiValuedAttribute
        """

        self._features = features

    @property
    def manufacture_info(self):
        """Gets the manufacture_info of this ItemInfo.  # noqa: E501


        :return: The manufacture_info of this ItemInfo.  # noqa: E501
        :rtype: ManufactureInfo
        """
        return self._manufacture_info

    @manufacture_info.setter
    def manufacture_info(self, manufacture_info):
        """Sets the manufacture_info of this ItemInfo.


        :param manufacture_info: The manufacture_info of this ItemInfo.  # noqa: E501
        :type: ManufactureInfo
        """

        self._manufacture_info = manufacture_info

    @property
    def product_info(self):
        """Gets the product_info of this ItemInfo.  # noqa: E501


        :return: The product_info of this ItemInfo.  # noqa: E501
        :rtype: ProductInfo
        """
        return self._product_info

    @product_info.setter
    def product_info(self, product_info):
        """Sets the product_info of this ItemInfo.


        :param product_info: The product_info of this ItemInfo.  # noqa: E501
        :type: ProductInfo
        """

        self._product_info = product_info

    @property
    def technical_info(self):
        """Gets the technical_info of this ItemInfo.  # noqa: E501


        :return: The technical_info of this ItemInfo.  # noqa: E501
        :rtype: TechnicalInfo
        """
        return self._technical_info

    @technical_info.setter
    def technical_info(self, technical_info):
        """Sets the technical_info of this ItemInfo.


        :param technical_info: The technical_info of this ItemInfo.  # noqa: E501
        :type: TechnicalInfo
        """

        self._technical_info = technical_info

    @property
    def title(self):
        """Gets the title of this ItemInfo.  # noqa: E501


        :return: The title of this ItemInfo.  # noqa: E501
        :rtype: SingleStringValuedAttribute
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ItemInfo.


        :param title: The title of this ItemInfo.  # noqa: E501
        :type: SingleStringValuedAttribute
        """

        self._title = title

    @property
    def trade_in_info(self):
        """Gets the trade_in_info of this ItemInfo.  # noqa: E501


        :return: The trade_in_info of this ItemInfo.  # noqa: E501
        :rtype: TradeInInfo
        """
        return self._trade_in_info

    @trade_in_info.setter
    def trade_in_info(self, trade_in_info):
        """Sets the trade_in_info of this ItemInfo.


        :param trade_in_info: The trade_in_info of this ItemInfo.  # noqa: E501
        :type: TradeInInfo
        """

        self._trade_in_info = trade_in_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ItemInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
