# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeStartStressTestRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'test_run_config': 'str',
        'typed_test_run_config': 'CliconfigTypedCLIConfig',
        'project_id': 'str',
        'managed_image': 'RimeManagedImageReference',
        'ram_request_megabytes': 'str',
        'cpu_request_millicores': 'str',
        'data_type': 'RimeDataType',
        'agent_id': 'str',
        'data_source_id': 'str'
    }

    attribute_map = {
        'test_run_config': 'testRunConfig',
        'typed_test_run_config': 'typedTestRunConfig',
        'project_id': 'projectId',
        'managed_image': 'managedImage',
        'ram_request_megabytes': 'ramRequestMegabytes',
        'cpu_request_millicores': 'cpuRequestMillicores',
        'data_type': 'dataType',
        'agent_id': 'agentId',
        'data_source_id': 'dataSourceId'
    }

    def __init__(self, test_run_config=None, typed_test_run_config=None, project_id=None, managed_image=None, ram_request_megabytes=None, cpu_request_millicores=None, data_type=None, agent_id=None, data_source_id=None):  # noqa: E501
        """RimeStartStressTestRequest - a model defined in Swagger"""  # noqa: E501
        self._test_run_config = None
        self._typed_test_run_config = None
        self._project_id = None
        self._managed_image = None
        self._ram_request_megabytes = None
        self._cpu_request_millicores = None
        self._data_type = None
        self._agent_id = None
        self._data_source_id = None
        self.discriminator = None
        if test_run_config is not None:
            self.test_run_config = test_run_config
        if typed_test_run_config is not None:
            self.typed_test_run_config = typed_test_run_config
        if project_id is not None:
            self.project_id = project_id
        if managed_image is not None:
            self.managed_image = managed_image
        if ram_request_megabytes is not None:
            self.ram_request_megabytes = ram_request_megabytes
        if cpu_request_millicores is not None:
            self.cpu_request_millicores = cpu_request_millicores
        if data_type is not None:
            self.data_type = data_type
        if agent_id is not None:
            self.agent_id = agent_id
        if data_source_id is not None:
            self.data_source_id = data_source_id

    @property
    def test_run_config(self):
        """Gets the test_run_config of this RimeStartStressTestRequest.  # noqa: E501

        Config of test run. Should be a json string.  # noqa: E501

        :return: The test_run_config of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._test_run_config

    @test_run_config.setter
    def test_run_config(self, test_run_config):
        """Sets the test_run_config of this RimeStartStressTestRequest.

        Config of test run. Should be a json string.  # noqa: E501

        :param test_run_config: The test_run_config of this RimeStartStressTestRequest.  # noqa: E501
        :type: str
        """

        self._test_run_config = test_run_config

    @property
    def typed_test_run_config(self):
        """Gets the typed_test_run_config of this RimeStartStressTestRequest.  # noqa: E501


        :return: The typed_test_run_config of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: CliconfigTypedCLIConfig
        """
        return self._typed_test_run_config

    @typed_test_run_config.setter
    def typed_test_run_config(self, typed_test_run_config):
        """Sets the typed_test_run_config of this RimeStartStressTestRequest.


        :param typed_test_run_config: The typed_test_run_config of this RimeStartStressTestRequest.  # noqa: E501
        :type: CliconfigTypedCLIConfig
        """

        self._typed_test_run_config = typed_test_run_config

    @property
    def project_id(self):
        """Gets the project_id of this RimeStartStressTestRequest.  # noqa: E501

        ID for the project under which to run this test. The project ID must already exist or an error will be returned.  # noqa: E501

        :return: The project_id of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this RimeStartStressTestRequest.

        ID for the project under which to run this test. The project ID must already exist or an error will be returned.  # noqa: E501

        :param project_id: The project_id of this RimeStartStressTestRequest.  # noqa: E501
        :type: str
        """

        self._project_id = project_id

    @property
    def managed_image(self):
        """Gets the managed_image of this RimeStartStressTestRequest.  # noqa: E501


        :return: The managed_image of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: RimeManagedImageReference
        """
        return self._managed_image

    @managed_image.setter
    def managed_image(self, managed_image):
        """Sets the managed_image of this RimeStartStressTestRequest.


        :param managed_image: The managed_image of this RimeStartStressTestRequest.  # noqa: E501
        :type: RimeManagedImageReference
        """

        self._managed_image = managed_image

    @property
    def ram_request_megabytes(self):
        """Gets the ram_request_megabytes of this RimeStartStressTestRequest.  # noqa: E501

        Megabytes of RAM requested for the stress test job. The limit is 2x the megabytes requested.  # noqa: E501

        :return: The ram_request_megabytes of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._ram_request_megabytes

    @ram_request_megabytes.setter
    def ram_request_megabytes(self, ram_request_megabytes):
        """Sets the ram_request_megabytes of this RimeStartStressTestRequest.

        Megabytes of RAM requested for the stress test job. The limit is 2x the megabytes requested.  # noqa: E501

        :param ram_request_megabytes: The ram_request_megabytes of this RimeStartStressTestRequest.  # noqa: E501
        :type: str
        """

        self._ram_request_megabytes = ram_request_megabytes

    @property
    def cpu_request_millicores(self):
        """Gets the cpu_request_millicores of this RimeStartStressTestRequest.  # noqa: E501

        Millicores of CPU requested for the stress test job. The limit is 2x the millicores requested.  # noqa: E501

        :return: The cpu_request_millicores of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._cpu_request_millicores

    @cpu_request_millicores.setter
    def cpu_request_millicores(self, cpu_request_millicores):
        """Sets the cpu_request_millicores of this RimeStartStressTestRequest.

        Millicores of CPU requested for the stress test job. The limit is 2x the millicores requested.  # noqa: E501

        :param cpu_request_millicores: The cpu_request_millicores of this RimeStartStressTestRequest.  # noqa: E501
        :type: str
        """

        self._cpu_request_millicores = cpu_request_millicores

    @property
    def data_type(self):
        """Gets the data_type of this RimeStartStressTestRequest.  # noqa: E501


        :return: The data_type of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: RimeDataType
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """Sets the data_type of this RimeStartStressTestRequest.


        :param data_type: The data_type of this RimeStartStressTestRequest.  # noqa: E501
        :type: RimeDataType
        """

        self._data_type = data_type

    @property
    def agent_id(self):
        """Gets the agent_id of this RimeStartStressTestRequest.  # noqa: E501

        agent_id is the agent this job should be run on. If not specified, the default agent for the workspace is used.  # noqa: E501

        :return: The agent_id of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """Sets the agent_id of this RimeStartStressTestRequest.

        agent_id is the agent this job should be run on. If not specified, the default agent for the workspace is used.  # noqa: E501

        :param agent_id: The agent_id of this RimeStartStressTestRequest.  # noqa: E501
        :type: str
        """

        self._agent_id = agent_id

    @property
    def data_source_id(self):
        """Gets the data_source_id of this RimeStartStressTestRequest.  # noqa: E501

        Name of the data source which is used in the arguments.  # noqa: E501

        :return: The data_source_id of this RimeStartStressTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this RimeStartStressTestRequest.

        Name of the data source which is used in the arguments.  # noqa: E501

        :param data_source_id: The data_source_id of this RimeStartStressTestRequest.  # noqa: E501
        :type: str
        """

        self._data_source_id = data_source_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeStartStressTestRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeStartStressTestRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
