# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class ScheduledJob(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'user_id': 'str',
        'inbox_id': 'str',
        'job_id': 'str',
        'group_id': 'str',
        'trigger_id': 'str',
        'status': 'str',
        'send_at_timestamp': 'datetime',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'user_id': 'userId',
        'inbox_id': 'inboxId',
        'job_id': 'jobId',
        'group_id': 'groupId',
        'trigger_id': 'triggerId',
        'status': 'status',
        'send_at_timestamp': 'sendAtTimestamp',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, user_id=None, inbox_id=None, job_id=None, group_id=None, trigger_id=None, status=None, send_at_timestamp=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """ScheduledJob - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._user_id = None
        self._inbox_id = None
        self._job_id = None
        self._group_id = None
        self._trigger_id = None
        self._status = None
        self._send_at_timestamp = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        self.id = id
        self.user_id = user_id
        self.inbox_id = inbox_id
        self.job_id = job_id
        self.group_id = group_id
        self.trigger_id = trigger_id
        self.status = status
        self.send_at_timestamp = send_at_timestamp
        self.created_at = created_at
        self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this ScheduledJob.  # noqa: E501


        :return: The id of this ScheduledJob.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ScheduledJob.


        :param id: The id of this ScheduledJob.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def user_id(self):
        """Gets the user_id of this ScheduledJob.  # noqa: E501


        :return: The user_id of this ScheduledJob.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this ScheduledJob.


        :param user_id: The user_id of this ScheduledJob.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def inbox_id(self):
        """Gets the inbox_id of this ScheduledJob.  # noqa: E501


        :return: The inbox_id of this ScheduledJob.  # noqa: E501
        :rtype: str
        """
        return self._inbox_id

    @inbox_id.setter
    def inbox_id(self, inbox_id):
        """Sets the inbox_id of this ScheduledJob.


        :param inbox_id: The inbox_id of this ScheduledJob.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and inbox_id is None:  # noqa: E501
            raise ValueError("Invalid value for `inbox_id`, must not be `None`")  # noqa: E501

        self._inbox_id = inbox_id

    @property
    def job_id(self):
        """Gets the job_id of this ScheduledJob.  # noqa: E501


        :return: The job_id of this ScheduledJob.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this ScheduledJob.


        :param job_id: The job_id of this ScheduledJob.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and job_id is None:  # noqa: E501
            raise ValueError("Invalid value for `job_id`, must not be `None`")  # noqa: E501

        self._job_id = job_id

    @property
    def group_id(self):
        """Gets the group_id of this ScheduledJob.  # noqa: E501


        :return: The group_id of this ScheduledJob.  # noqa: E501
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this ScheduledJob.


        :param group_id: The group_id of this ScheduledJob.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and group_id is None:  # noqa: E501
            raise ValueError("Invalid value for `group_id`, must not be `None`")  # noqa: E501

        self._group_id = group_id

    @property
    def trigger_id(self):
        """Gets the trigger_id of this ScheduledJob.  # noqa: E501


        :return: The trigger_id of this ScheduledJob.  # noqa: E501
        :rtype: str
        """
        return self._trigger_id

    @trigger_id.setter
    def trigger_id(self, trigger_id):
        """Sets the trigger_id of this ScheduledJob.


        :param trigger_id: The trigger_id of this ScheduledJob.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and trigger_id is None:  # noqa: E501
            raise ValueError("Invalid value for `trigger_id`, must not be `None`")  # noqa: E501

        self._trigger_id = trigger_id

    @property
    def status(self):
        """Gets the status of this ScheduledJob.  # noqa: E501


        :return: The status of this ScheduledJob.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ScheduledJob.


        :param status: The status of this ScheduledJob.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["SUBMITTED", "COMPLETED", "FAILED", "CANCELLED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def send_at_timestamp(self):
        """Gets the send_at_timestamp of this ScheduledJob.  # noqa: E501


        :return: The send_at_timestamp of this ScheduledJob.  # noqa: E501
        :rtype: datetime
        """
        return self._send_at_timestamp

    @send_at_timestamp.setter
    def send_at_timestamp(self, send_at_timestamp):
        """Sets the send_at_timestamp of this ScheduledJob.


        :param send_at_timestamp: The send_at_timestamp of this ScheduledJob.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and send_at_timestamp is None:  # noqa: E501
            raise ValueError("Invalid value for `send_at_timestamp`, must not be `None`")  # noqa: E501

        self._send_at_timestamp = send_at_timestamp

    @property
    def created_at(self):
        """Gets the created_at of this ScheduledJob.  # noqa: E501


        :return: The created_at of this ScheduledJob.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ScheduledJob.


        :param created_at: The created_at of this ScheduledJob.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this ScheduledJob.  # noqa: E501


        :return: The updated_at of this ScheduledJob.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ScheduledJob.


        :param updated_at: The updated_at of this ScheduledJob.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduledJob):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ScheduledJob):
            return True

        return self.to_dict() != other.to_dict()
