"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ses = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ses-receipt');
const ruleSet = new ses.ReceiptRuleSet(stack, 'RuleSet', {
    dropSpam: true,
});
ruleSet.addRule('FirstRule', {
    receiptRuleName: 'FirstRule',
    recipients: ['cdk-ses-receipt-test@yopmail.com'],
    scanEnabled: true,
    tlsPolicy: ses.TlsPolicy.REQUIRE,
});
ruleSet.addRule('SecondRule');
new ses.WhiteListReceiptFilter(stack, 'WhiteList', {
    ips: [
        '10.0.0.0/16',
    ],
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcucmVjZWlwdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLnJlY2VpcHQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBcUM7QUFDckMsOEJBQThCO0FBRTlCLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUscUJBQXFCLENBQUMsQ0FBQztBQUV4RCxNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRTtJQUN2RCxRQUFRLEVBQUUsSUFBSTtDQUNmLENBQUMsQ0FBQztBQUVILE9BQU8sQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFO0lBQzNCLGVBQWUsRUFBRSxXQUFXO0lBQzVCLFVBQVUsRUFBRSxDQUFDLGtDQUFrQyxDQUFDO0lBQ2hELFdBQVcsRUFBRSxJQUFJO0lBQ2pCLFNBQVMsRUFBRSxHQUFHLENBQUMsU0FBUyxDQUFDLE9BQU87Q0FDakMsQ0FBQyxDQUFDO0FBRUgsT0FBTyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztBQUU5QixJQUFJLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO0lBQ2pELEdBQUcsRUFBRTtRQUNILGFBQWE7S0FDZDtDQUNGLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIHNlcyBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1zZXMtcmVjZWlwdCcpO1xuXG5jb25zdCBydWxlU2V0ID0gbmV3IHNlcy5SZWNlaXB0UnVsZVNldChzdGFjaywgJ1J1bGVTZXQnLCB7XG4gIGRyb3BTcGFtOiB0cnVlLFxufSk7XG5cbnJ1bGVTZXQuYWRkUnVsZSgnRmlyc3RSdWxlJywge1xuICByZWNlaXB0UnVsZU5hbWU6ICdGaXJzdFJ1bGUnLFxuICByZWNpcGllbnRzOiBbJ2Nkay1zZXMtcmVjZWlwdC10ZXN0QHlvcG1haWwuY29tJ10sXG4gIHNjYW5FbmFibGVkOiB0cnVlLFxuICB0bHNQb2xpY3k6IHNlcy5UbHNQb2xpY3kuUkVRVUlSRSxcbn0pO1xuXG5ydWxlU2V0LmFkZFJ1bGUoJ1NlY29uZFJ1bGUnKTtcblxubmV3IHNlcy5XaGl0ZUxpc3RSZWNlaXB0RmlsdGVyKHN0YWNrLCAnV2hpdGVMaXN0Jywge1xuICBpcHM6IFtcbiAgICAnMTAuMC4wLjAvMTYnLFxuICBdLFxufSk7XG4iXX0=