# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['wcheck']

package_data = \
{'': ['*']}

install_requires = \
['gitpython>=3.1.29,<4.0.0',
 'pendulum>=2.1.2,<3.0.0',
 'pyside6>=6.4.0,<7.0.0',
 'pyyaml>=6.0,<7.0',
 'rich>=12.6.0,<13.0.0']

entry_points = \
{'console_scripts': ['wcheck = wcheck.wcheck:main']}

setup_kwargs = {
    'name': 'wcheck',
    'version': '0.1.3',
    'description': 'Compare a workspace of git repositories and its configuration file.',
    'long_description': '# Workspace Check (wcheck)\n\nCompares different versions of git repositories and reports their differences. Possible options of workspace:\n- local workspace in a directory, represented by the current git branch of each repository\n- workspace defined by a vcs file\n\nPossible comparisions:\n- compare local workspace against a configuration file (command=wconfig)\n- compare two configuration files, e.g. robot_A.vcs with robot_B.vcs (command=config_list)\n- compare all git references of a configurion file, this includes all active branches and tags (command=config_versions)\n\n\n## Usage\n\nGeneral usage\n```bash\nwcheck <command> <parameters>\n```\nCommand options: status, wconfig, config_list, config_versions\n\nCheck workspace status\n```bash\nwcheck status [-w <workspace_location>] [--full] [--gui] [-v] [--show-time] \n```\nIt will show the git status of each repository. The legend is U: number of untracked files, C: number of changed files, S: number of staged files, arrow up: number of commits to push, arrow down: number of commits to pull.\n\nWorkspace location can be specified with argument _-w_, if not provided, it will use current location. \n\nCompare workspace to a configuration file:\n```bash\nwcheck wconfig -c <config_file> [--gui] [-v] [--show-time]\n```\nThe configuration file uses VCSTOOL structure, see an overview below\n\nCompare multiple configuration files\n```bash\nwcheck config_list -c <config_A> <config_B> .. <config_N>\n```\n\nCompare git references (branches and tags), of the configuration file\n```bash\nwcheck config_versions -c <config> [-h] [--full] [-v] [--show-time] [--full-path]\n```\n\nOptional arguments\n```\n  -v --verbose: verbose output\n  -h --help: show help\n  --full: show full output, not only differences\n  --gui: show graphical user interface\n  --show-time: show elapsed time since last commit and reference creation\n  --fetch: fetch repositories before comparing\n  --full-path: show full path for each configuration file\n```\n\n## VCSTOOL Overview\n\nThis repo is based on vcstool (do not confuse with [vctools](https://github.com/vcstools/vcstools/), a similar but deprecated tool for working with vcs files). A workspace is defined with a yaml file describing each repository\n\n```yaml\n  repositories:\n    <repo directory name>:\n      type: <repo type>\n      url: <repo url>\n      version: <repo version>\n```\n\nwhere *repo directory name* is the name of the directory where the repo is cloned to (including parent folders in any), *repo url* is the url of the repo (using git or https), *repo type* is the type of repo (git, hg, svn, bzr, etc), and *repo version* is the version of the repo to check against, specified as a branch name, tag name, or commit hash. Example:\n\n```yaml\n  repositories:\n    vcstool:\n      type: git\n      url: git@github.com:dirk-thomas/vcstool.git\n      version: master\n```\n## Other multi-repository tools\n\n\n\n| Name                                                                         | Status    | Last release  | Language | Git interaction      | Terminal | GUI | Compares configs | Compares versions | Description                                                                                                     |\n|------------------------------------------------------------------------------|-----------|---------------|----------|----------------------|----------|-----|------------------|-------------------|-----------------------------------------------------------------------------------------------------------------|\n| <a href="https://github.com/davvid/garden/">garden</a>                       | active    | July 2022     | Rust     | native rust          | Yes      | no  | no               | no                | manage git project dependencies and worktrees, custom commands                                                  |\n| <a href="https://github.com/nickgerace/gfold">gfold</a>                      | active    | July 2022     | Rust     | native rust          | Yes      | no  |                  |                   | lists status of multiple repositories, readonly, config file, rust                                              |\n| <a href="https://github.com/motemen/ghq">ghq</a>                             | active    | May 2022      | Go       |                      | yes      |     |                  |                   | manage remote repository clones                                                                                 |\n| <a href="https://github.com/tkrajina/git-plus">git-plus</a>                  | active    | August 2022   | Python   | git cli w/subprocess |          |     |                  |                   | multi: run commands in multiple git repos                                                                       |\n| <a href="https://github.com/earwig/git-repo-updater">git-repo-updater</a>    | old       | 2019          | Python   | python gitRepo       |          |     |                  |                   | gitup: update multiple git repos at once                                                                        |\n| <a href="https://github.com/nosarthur/gita">gita</a>                         | active    | January 2022  | Python   | git cli w/subprocess |          |     |                  |                   | manage multiple git repos                                                                                       |\n| <a href="https://github.com/isacikgoz/gitbatch">gitbatch</a>                 |           |               | Go       |                      |          |     |                  |                   | manage multiple git repos in one place                                                                          |\n| <a href="https://github.com/Masterminds/vcs">go-vcs</a>                      | active    | March 2022    | Go       |                      |          |     |                  |                   | version control repository management for Golang                                                                |\n| <a href="https://github.com/siemens/kas">kas</a>                             | active    | August 2022   | Python   |                      |          |     |                  |                   | bitbake repository management tool                                                                              |\n| <a href="https://github.com/fboender/multi-git-status">mgitstatus</a>        | active    | June 2022     | Bash     | git cli              |          |     |                  |                   | show status in multiple git repos                                                                               |\n| <a href="https://manicli.com/">mani</a>                                      | active    | June 2022     |          |                      |          |     |                  |                   | manage multiple repositories, tasks, tags, YAML config, golang                                                  |\n| <a href="https://github.com/lindell/multi-gitter">multi-gitter</a>           | active    | August 2022   | Go       |                      |          |     |                  |                   | run command and commit, manipulates pull requests, YAML config, tightly bound to forges (GitHub, GitLab, Gitea) |\n| <a href="https://fabioz.github.io/mu-repo/">mu-repo</a>                      | active    | Octover 20220 | Python   |                      |          |     |                  |                   | help working with multiple git repos                                                                            |\n| <a href="https://android.googlesource.com/tools/repo">repo</a>               | active    |               |          |                      |          |     |                  |                   | git repository management tool                                                                                  |\n| <a href="https://github.com/vcstools/rosinstall">rosinstall</a>              | archived  | 2016          | Python   |                      |          |     |                  |                   | source code workspace management tool                                                                           |\n| <a href="https://www.jelmer.uk/silver-platter-intro.html">silver-platter</a> | active    | March 2022    | Python   |                      |          |     |                  |                   | make automated changes in different version control repositories                                                |\n| <a href="https://github.com/brandon-rhodes/uncommitted">uncommitted</a>      | active    | January 2021  | Python   |                      |          |     |                  |                   | find uncommitted changes in VCS directories                                                                     |\n| <a href="https://github.com/ChristophBerg/dotfiles/blob/master/bin/v">v</a>  | abandoned | 2009          | Bash     |                      |          |     |                  |                   | version control subcommand wrapper                                                                              |\n| <a href="https://www.greenend.org.uk/rjk/vcs/">VCS</a>                       | abandoned | 2018          |          |                      |          |     |                  |                   | a wrapper for version control systems                                                                           |\n| <a href="https://github.com/xolox/python-vcs-repo-mgr">vcs-repo-mgr</a>      | abandoned | 2018          | Python   |                      |          |     |                  |                   | version control repository manager                                                                              |\n| <a href="https://github.com/dirk-thomas/vcstool">vcstool</a>                 | active    |               | Python   | git cli w/subprocess |          |     |                  |                   | work with multiple repositories                                                                                 |\n| <a href="https://github.com/vcstools/vcstools">vcstools</a>                  | archived  |               | Python   |                      |          |     |                  |                   | Python API wrapping version control systems                                                                     |\n| <a href="https://github.com/vcstools/wstool">wstool</a>                      | archived  |               | Python   |                      |          |     |                  |                   | maintain workspace of projects from multiple VCSes                                                              |',
    'author': 'Daniel Pastor',
    'author_email': 'danpasmor@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
