# Blackjack

## Usage
Perform the equivalent of the below line;
`pipenv install --python 3.7 x10-blackjack` (Tip: can also replace `pipenv install --python 3.7` with just `pip`).

And then, from within the same (hopefully virtual) environment you've now installed `x10-blackjack` into, execute with something equivalent to;
`pipenv run blackjack`

### If you instead want to install via Git
Ensure you've got `python3.7` and `pipenv` available on `$PATH`.
- PS: https://pipenv.pypa.io/en/latest/install/#installing-pipenv
Then perform `make install` as referenced in Developer/Installation steps.

## Developer Usage
### Automatic pipeline
This repository has a pipeline triggering on any and all commits pushed.
(Also merge-requests created).

So, if pipeline passes okay, then all is good.
Read on for further details on how to set-up dev-environment locally/manually.

### Requirements
1. `pipenv` available through PATH (e.g. installed through `pipsi` so as to contain it to USER PATH env).
2. `python3.7`

#### Docker
Execute the equivalent of the `Makefile`s `make docker` (and thus nothing besides `docker` is required on developer machine).

### Installation steps
1. `git clone <clone url>`
2. `cd <into cloned repo folder root>`
3. `make install`

### Development iteration steps
1. `<modify code>`
2. `make check_all` (or `make check_quick` if you don't want to run slower integration tests).
3. `make run`
4. `<feature/change specific test(s)>`
Repeat any steps (or sequence of them) as needed until `make check_all` passes before pushing to `master` branch (ideally...).

### Upload to PyPI manually
1. First create package; `make package`
2. Then upload `pipenv run twine upload dist/*`
Note: The command in list-item #2 relies on the variables `TWINE_USERNAME="__token__"` and `TWINE_PASSWORD=<token string>` having been set.

### Upload to PyPI automatically (read: with (GitLab) pipeline)
Push a `git tag` where the name of the tag is a semantic version (`<major>.<minor>.<patch>`).
