"""rename_source_id_column_in_data_sources_table

Revision ID: e0c2f9aff251
Revises: 919dc9f1dc1f
Create Date: 2018-07-20 16:08:50.641000

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "e0c2f9aff251"
down_revision = "919dc9f1dc1f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("data_sources", sa.Column("user_id", sa.Integer(), nullable=True))
    op.drop_constraint(
        "data_sources_source_id_fkey", "data_sources", type_="foreignkey"
    )
    op.create_foreign_key(None, "data_sources", "bvp_users", ["user_id"], ["id"])
    op.drop_column("data_sources", "source_id")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "data_sources",
        sa.Column("source_id", sa.INTEGER(), autoincrement=False, nullable=True),
    )
    op.drop_constraint(None, "data_sources", type_="foreignkey")
    op.create_foreign_key(
        "data_sources_source_id_fkey",
        "data_sources",
        "bvp_users",
        ["source_id"],
        ["id"],
    )
    op.drop_column("data_sources", "user_id")
    # ### end Alembic commands ###
