# generated by datamodel-codegen:
#   filename:  schema/type/changeEvent.json
#   timestamp: 2021-11-09T23:02:30+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Optional

from pydantic import BaseModel, Extra, Field

from . import basic


class Operation(BaseModel):
    __root__: Any


class EventType(Enum):
    ENTITY_CREATED = 'ENTITY_CREATED'
    ENTITY_UPDATED = 'ENTITY_UPDATED'
    ENTITY_DELETED = 'ENTITY_DELETED'
    ENTITY_FOLLOWED = 'ENTITY_FOLLOWED'
    ENTITY_UNFOLLOWED = 'ENTITY_UNFOLLOWED'


class ChangeEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    eventType: EventType
    entityType: Optional[str] = Field(
        None,
        description='Entity type that changed. Use the schema of this entity to process the entity attribute.',
    )
    entity: Any = Field(..., description='Entity that changed.')
    userName: str = Field(
        ..., description='Name of the user whose activity resulted in the change.'
    )
    operation: Operation = Field(
        ...,
        description='API operation that was result of user activity resulted in the change.',
    )
    dateTime: basic.DateTime = Field(
        ..., description='Date and time when the change was made.'
    )
