# generated by datamodel-codegen:
#   filename:  schema/api/data/createModel.json
#   timestamp: 2021-11-09T16:16:34+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field, constr

from ...entity.data import model
from ...type import entityReference, tagLabel


class CreateModelEntityRequest(BaseModel):
    name: constr(min_length=1, max_length=64) = Field(
        ..., description='Name that identifies this model.'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this model. It could be title or label from the source services',
    )
    description: Optional[str] = Field(
        None,
        description='Description of the model instance. How it was trained and for what it is used.',
    )
    algorithm: str = Field(..., description='Algorithm used to train the model')
    mlFeatures: Optional[List[model.MlFeature]] = Field(
        None, description='Features used to train the ML Model.'
    )
    mlHyperParameters: Optional[List[model.MlHyperParameter]] = Field(
        None, description='Hyper Parameters used to train the ML Model.'
    )
    dashboard: Optional[entityReference.EntityReference] = Field(
        None, description='Performance Dashboard URL to track metric evolution'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this model'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this database'
    )
