from tkinter import *
from tkinter import ttk
from typing import Literal


class DevPreTooltip(Toplevel):
    def __init__(self, widget: Widget, window: Tk, message: str = "", after: int = 1000, border: bool = True, padding: int = 3, side=CENTER, height: int = 40,
                 background="#ffffff", foreground="#000000"):
        super(DevPreTooltip, self).__init__()
        self.configure(background=background, relief=RAISED, border=1)
        from tkdev import window_border
        self._message = Label(self, background=background, foreground=foreground, text=message)
        self._message.pack(padx=padding, pady=padding, ipadx=padding, ipady=padding, fill=BOTH, expand=YES)
        if border:
            window_border(self)
        if not border:
            self.overrideredirect(True)
        self.withdraw()

        self.widget = widget
        self.window = window
        self._height = height
        self._afterms = after
        self.side = side
        self.padding = padding

        self.ison = False

        self.widget.bind("<Enter>", lambda evt: self.show())
        self.widget.bind("<Leave>", lambda evt: self.hide())

        self.geometry(f"{self.widget.winfo_width()}x{self._height}")

    @property
    def after_ms(self):
        return self._afterms

    @after_ms.setter
    def after_ms(self, ms: int = 1000):
        self._afterms = ms

    @property
    def message(self):
        return self.message

    @message.setter
    def message(self, text: str):
        self._message.configure(text=text)

    def hide(self):
        self.ison = False
        self.window.deiconify()
        self.withdraw()

    def show(self):
        self.ison = True

        def on():
            self.geometry(f"{self.widget.winfo_width()}x{self._height}")
            print(self._message.winfo_height())
            if self.ison:
                if self.side == "center":
                    self.geometry(f"+{self.widget.winfo_rootx() - 7}+{self.widget.winfo_rooty() + self.widget.winfo_height() + 5}")
                self.deiconify()

        self.after(self._afterms, on)


class DevPreToolbox(Toplevel):
    def __init__(self, master: Tk, title: str = "ToolBox"):
        super(DevPreToolbox, self).__init__()
        from tkdev import window_move, window_border
        from tkinter import ttk

        self.geometry("355x450")
        self.title = Label(self, text=title, background="#fcfcfc")
        self.title.pack(fill=X, side=TOP)

        window_move(self.title, self)
        window_border(self)
        self.Title_Button = ttk.Button(self, text="修改标题", command=self.set_title)
        self.Title_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Topmost_Button = ttk.Button(self, text="置顶", command=self.set_topmost)
        self.Topmost_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.No_Topmost_Button = ttk.Button(self, text="取消置顶", command=self.set_no_topmost)
        self.No_Topmost_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Mica_Light_Button = ttk.Button(self, text="云母特效-浅色", command=self.mica_light)
        self.Mica_Light_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Mica_Dark_Button = ttk.Button(self, text="云母特效-深色", command=self.mica_dark)
        self.Mica_Dark_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Close_Button = ttk.Button(self, text="关闭窗口", command=self.master.destroy)
        self.Close_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.master = master

    def set_title(self):
        from tkinter import simpledialog
        title = simpledialog.askstring("输入标题", "请设置窗口的标题")
        self.master.title(title)

    def set_topmost(self):
        self.master.attributes("-topmost", True)

    def set_no_topmost(self):
        self.master.attributes("-topmost", False)

    def mica_light(self):
        from tkdev import window_mica_light
        window_mica_light(self.master)
        self.master.configure(background="#ffffff")

    def mica_dark(self):
        from tkdev import window_mica_dark
        window_mica_dark(self.master)
        self.master.configure(background="#000000")

    def show(self):
        self.mainloop()


if __name__ == '__main__':
    Window = Tk()
    Window.title("Hello")
    Button = ttk.Button()
    Button.pack()
    Tooltip = DevPreTooltip(Button, Window, "Hello")
    Tooltip.after_ms = 500
    Window.mainloop()
