from sqlalchemy import Column, Sequence
from sqlalchemy.dialects.postgresql import DOUBLE_PRECISION, UUID, TIMESTAMP, TIME
from sqlalchemy.types import VARCHAR, BIGINT, DATE, INTEGER, NUMERIC, BOOLEAN, TEXT
from base import PrimaryBase

class InpLinkAm(PrimaryBase):
    __tablename__ = 'inp_link_am'
    __table_args__ = {'schema': 'public'}
    
    id = Column(INTEGER, primary_key=True, autoincrement=True)
    city = Column(VARCHAR(50), autoincrement=False)
    name = Column(VARCHAR(250), autoincrement=False)
    is_ineligib = Column(VARCHAR(25), autoincrement=False)
    is_cond_est = Column(VARCHAR(25), autoincrement=False)
    source = Column(VARCHAR(25), autoincrement=False)
    comments = Column(VARCHAR(25), autoincrement=False)
    watershed_name = Column(VARCHAR(25), autoincrement=False)
    owner = Column(VARCHAR(25), autoincrement=False)
    ins_date = Column(VARCHAR(25), autoincrement=False)
    shape = Column(VARCHAR(25), autoincrement=False)
    dim1 = Column(VARCHAR(25), autoincrement=False)
    dim2 = Column(VARCHAR(25), autoincrement=False)
    no_barrels = Column(VARCHAR(25), autoincrement=False)
    length = Column(VARCHAR(25), autoincrement=False)
    material = Column(VARCHAR(25), autoincrement=False)
    line_type = Column(VARCHAR(25), autoincrement=False)
    main_type = Column(VARCHAR(25), autoincrement=False)
    us_node = Column(VARCHAR(250), autoincrement=False)
    ds_node = Column(VARCHAR(250), autoincrement=False)
    dep_cover = Column(VARCHAR(25), autoincrement=False)
    us_inv_elev = Column(VARCHAR(25), autoincrement=False)
    ds_inv_elev = Column(VARCHAR(25), autoincrement=False)
    slope = Column(VARCHAR(25), autoincrement=False)
    jnt_type = Column(VARCHAR(25), autoincrement=False)
    asso_str = Column(VARCHAR(25), autoincrement=False)
    lat_con = Column(VARCHAR(25), autoincrement=False)
    bed_cond = Column(VARCHAR(25), autoincrement=False)
    trench_bf = Column(VARCHAR(25), autoincrement=False)
    des_life = Column(VARCHAR(25), autoincrement=False)
    des_storm = Column(VARCHAR(25), autoincrement=False)
    function = Column(VARCHAR(25), autoincrement=False)
    thickness = Column(VARCHAR(25), autoincrement=False)
    coating = Column(VARCHAR(25), autoincrement=False)
    lining = Column(VARCHAR(25), autoincrement=False)
    status = Column(VARCHAR(25), autoincrement=False)
    line_cond = Column(VARCHAR(25), autoincrement=False)
    ext_coat_cond = Column(VARCHAR(25), autoincrement=False)
    ht_bedding = Column(VARCHAR(25), autoincrement=False)
    des_str_pipe = Column(VARCHAR(25), autoincrement=False)
    pl_ins_date = Column(VARCHAR(25), autoincrement=False)
    ext_coat_age = Column(VARCHAR(25), autoincrement=False)
    pipe_vint = Column(VARCHAR(25), autoincrement=False)
    pipe_class = Column(VARCHAR(25), autoincrement=False)
    a_struc_cond = Column(VARCHAR(25), autoincrement=False)
    dis_mater = Column(VARCHAR(25), autoincrement=False)
    pg_full_len = Column(VARCHAR(25), autoincrement=False)
    soil_type = Column(VARCHAR(25), autoincrement=False)
    gw_table = Column(VARCHAR(25), autoincrement=False)
    location = Column(VARCHAR(25), autoincrement=False)
    dead_load = Column(VARCHAR(25), autoincrement=False)
    live_load = Column(VARCHAR(25), autoincrement=False)
    av_preci_int = Column(VARCHAR(25), autoincrement=False)
    av_preci_dur = Column(VARCHAR(25), autoincrement=False)
    frost_pen = Column(VARCHAR(25), autoincrement=False)
    s_corro = Column(VARCHAR(25), autoincrement=False)
    near_trees = Column(VARCHAR(25), autoincrement=False)
    pipe_dir = Column(VARCHAR(25), autoincrement=False)
    ext_temp = Column(VARCHAR(25), autoincrement=False)
    his_ext_eve = Column(VARCHAR(25), autoincrement=False)
    catch_area = Column(VARCHAR(25), autoincrement=False)
    ws_int = Column(VARCHAR(25), autoincrement=False)
    wet_dry_cyc = Column(VARCHAR(25), autoincrement=False)
    nn_homo_soil = Column(VARCHAR(25), autoincrement=False)
    aci_runoff = Column(VARCHAR(25), autoincrement=False)
    soil_res = Column(VARCHAR(25), autoincrement=False)
    soil_dis = Column(VARCHAR(25), autoincrement=False)
    soil_sul = Column(VARCHAR(25), autoincrement=False)
    soil_ph = Column(VARCHAR(25), autoincrement=False)
    soil_moi_ret = Column(VARCHAR(25), autoincrement=False)
    st_curr = Column(VARCHAR(25), autoincrement=False)
    tidal_inf = Column(VARCHAR(25), autoincrement=False)
    av_flow_vel = Column(VARCHAR(25), autoincrement=False)
    min_flow_vel = Column(VARCHAR(25), autoincrement=False)
    max_flow_vel = Column(VARCHAR(25), autoincrement=False)
    ave_pres = Column(VARCHAR(25), autoincrement=False)
    min_pres = Column(VARCHAR(25), autoincrement=False)
    max_pres = Column(VARCHAR(25), autoincrement=False)
    known_leak = Column(VARCHAR(25), autoincrement=False)
    of_freq = Column(VARCHAR(25), autoincrement=False)
    surcharge = Column(VARCHAR(25), autoincrement=False)
    inflow_infil = Column(VARCHAR(25), autoincrement=False)
    exfiltration = Column(VARCHAR(25), autoincrement=False)
    deb_level = Column(VARCHAR(25), autoincrement=False)
    sed_level = Column(VARCHAR(25), autoincrement=False)
    smell_level = Column(VARCHAR(25), autoincrement=False)
    stag_water = Column(VARCHAR(25), autoincrement=False)
    flooding = Column(VARCHAR(25), autoincrement=False)
    dep_by_dia = Column(VARCHAR(25), autoincrement=False)
    maint_fre = Column(VARCHAR(25), autoincrement=False)
    vel_flow_spl = Column(VARCHAR(25), autoincrement=False)
    outlet_prot = Column(VARCHAR(25), autoincrement=False)
    conv_cap = Column(VARCHAR(25), autoincrement=False)
    mode_res_av = Column(VARCHAR(25), autoincrement=False)
    res_2yr = Column(VARCHAR(25), autoincrement=False)
    res_5yr = Column(VARCHAR(25), autoincrement=False)
    res_10yr = Column(VARCHAR(25), autoincrement=False)
    res_25yr = Column(VARCHAR(25), autoincrement=False)
    res_50yr = Column(VARCHAR(25), autoincrement=False)
    res_100yr = Column(VARCHAR(25), autoincrement=False)
    res_500yr = Column(VARCHAR(25), autoincrement=False)
    lt_sim_res = Column(VARCHAR(25), autoincrement=False)
    pacp_cond = Column(VARCHAR(25), autoincrement=False)
    mt_rec = Column(VARCHAR(191), autoincrement=False)
    cctv_rec = Column(VARCHAR(191), autoincrement=False)
    ren_rec = Column(VARCHAR(191), autoincrement=False)
    fail_rec = Column(VARCHAR(191), autoincrement=False)
    comp_rec = Column(VARCHAR(191), autoincrement=False)
    cap_cost = Column(VARCHAR(25), autoincrement=False)
    yr_om_cost = Column(VARCHAR(25), autoincrement=False)
    con_spec = Column(VARCHAR(25), autoincrement=False)
    lof = Column(VARCHAR(25), autoincrement=False)
    eco_imp = Column(VARCHAR(25), autoincrement=False)
    trans_imp = Column(VARCHAR(25), autoincrement=False)
    crit_imp = Column(VARCHAR(25), autoincrement=False)
    utility_imp = Column(VARCHAR(25), autoincrement=False)
    tmdl_imp = Column(VARCHAR(25), autoincrement=False)
    under_pave = Column(VARCHAR(25), autoincrement=False)
    proxi_rail = Column(VARCHAR(25), autoincrement=False)
    repl_cost = Column(VARCHAR(25), autoincrement=False)
    cof = Column(VARCHAR(25), autoincrement=False)
    bre = Column(VARCHAR(25), autoincrement=False)
    cip_id = Column(VARCHAR(25), autoincrement=False)
    max_allow_vel = Column(VARCHAR(191), autoincrement=False)
    max_allow_pres = Column(VARCHAR(191), autoincrement=False)
    mt_score = Column(VARCHAR(191), autoincrement=False)
    vs_inspect_rec = Column(VARCHAR(191), autoincrement=False)
    vs_inspect_score = Column(VARCHAR(191), autoincrement=False)
    em_inspect_rec = Column(VARCHAR(191), autoincrement=False)
    em_inspect_score = Column(VARCHAR(191), autoincrement=False)
    cctv_score = Column(VARCHAR(191), autoincrement=False)
    ac_inspect_rec = Column(VARCHAR(191), autoincrement=False)
    ac_inspect_score = Column(VARCHAR(191), autoincrement=False)
    ultra_test_rec = Column(VARCHAR(191), autoincrement=False)
    ultra_test_score = Column(VARCHAR(191), autoincrement=False)
    pipe_map_rec = Column(VARCHAR(191), autoincrement=False)
    pipe_map_score = Column(VARCHAR(191), autoincrement=False)
    radio_test_rec = Column(VARCHAR(191), autoincrement=False)
    radio_test_score = Column(VARCHAR(191), autoincrement=False)
    thermo_test_rec = Column(VARCHAR(191), autoincrement=False)
    thermo_test_score = Column(VARCHAR(191), autoincrement=False)
    other_test_rec = Column(VARCHAR(191), autoincrement=False)
    other_test_score = Column(VARCHAR(191), autoincrement=False)
    ren_score = Column(VARCHAR(191), autoincrement=False)
    fail_score = Column(VARCHAR(191), autoincrement=False)
    comp_score = Column(VARCHAR(191), autoincrement=False)
    rem_use_life = Column(VARCHAR(191), autoincrement=False)
    watershed_id = Column(VARCHAR(191), autoincrement=False)
    huc_12_id = Column(VARCHAR(191), autoincrement=False)
    land_use = Column(VARCHAR(191), autoincrement=False)
    tree_canopy = Column(VARCHAR(191), autoincrement=False)
    last_inspection_date = Column(VARCHAR(191), autoincrement=False)
    construction_performance_index = Column(VARCHAR(191), autoincrement=False)
    mukey = Column(VARCHAR(191), autoincrement=False)
    cond_comments = Column(VARCHAR(191), autoincrement=False)
    flow_area = Column(VARCHAR(191), autoincrement=False)
    proxi_road = Column(VARCHAR(191), autoincrement=False)
    proxi_gas = Column(VARCHAR(191), autoincrement=False)
    proxi_elec = Column(VARCHAR(191), autoincrement=False)
    severity_imp = Column(VARCHAR(191), autoincrement=False)
    usnodeid = Column(VARCHAR(191), autoincrement=False)
    dsnodeid = Column(VARCHAR(191), autoincrement=False)
    pred_dsinvelev = Column(VARCHAR(191), autoincrement=False)
    pred_usinvelev = Column(VARCHAR(191), autoincrement=False)
    pred_material = Column(VARCHAR(191), autoincrement=False)
    pred_dim1 = Column(VARCHAR(191), autoincrement=False)
    pred_dim2 = Column(VARCHAR(191), autoincrement=False)
    pred_lineshape = Column(VARCHAR(191), autoincrement=False)
    pred_nobarrels = Column(VARCHAR(191), autoincrement=False)
    project_id = Column(INTEGER, autoincrement=False)
    neerstndstr = Column(VARCHAR(191), autoincrement=False)
