/*
 * Decompiled with CFR 0.152.
 */
package treelib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jpmml.python.PythonObject;
import treelib.Node;

public class Tree
extends PythonObject {
    public Tree(String module, String name) {
        super(module, name);
    }

    public Node selectRoot() {
        Integer root = this.getRoot();
        return this.selectNode(root);
    }

    public Node selectNode(Integer identifier) {
        Map<Integer, Node> nodes = this.getNodes();
        Node node = nodes.get(identifier);
        if (node == null) {
            throw new IllegalArgumentException();
        }
        return node;
    }

    public List<Node> selectNodes(Collection<Integer> identifiers) {
        Map<Integer, Node> nodes = this.getNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        for (Integer identifier : identifiers) {
            Node node = nodes.get(identifier);
            if (node == null) {
                throw new IllegalArgumentException();
            }
            result.add(node);
        }
        return result;
    }

    public String getIdentifier() {
        return this.getString("_identifier");
    }

    public Map<Integer, Node> getNodes() {
        return (Map)this.get("_nodes", Map.class);
    }

    public Integer getRoot() {
        return this.getInteger("root");
    }
}

