/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.devsmart.ubjson.GsonUtil;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.BitSet;
import org.jpmml.xgboost.JSONLoadable;
import org.jpmml.xgboost.Node;
import org.jpmml.xgboost.UBJSONLoadable;

public class JSONNode
extends Node
implements JSONLoadable,
UBJSONLoadable {
    private int parent;
    private int left_child;
    private int right_child;
    private boolean default_left;
    private int split_index;
    private int split_type;
    private float split_condition;
    private BitSet split_categories;

    @Override
    public void loadJSON(JsonObject node) {
        UBValue value = GsonUtil.toUBValue((JsonElement)node);
        this.loadUBJSON(value.asObject());
    }

    @Override
    public void loadUBJSON(UBObject node) {
        this.parent = node.get((Object)"parent").asInt();
        this.left_child = node.get((Object)"left_child").asInt();
        this.right_child = node.get((Object)"right_child").asInt();
        this.default_left = node.get((Object)"default_left").asBool();
        this.split_index = node.get((Object)"split_index").asInt();
        this.split_type = node.get((Object)"split_type").asInt();
        this.split_condition = node.get((Object)"split_condition").asFloat32();
        switch (this.split_type) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean is_leaf() {
        return this.left_child == -1;
    }

    @Override
    public int left_child() {
        return this.left_child;
    }

    @Override
    public int right_child() {
        return this.right_child;
    }

    @Override
    public boolean default_left() {
        return this.default_left;
    }

    @Override
    public int split_type() {
        return this.split_type;
    }

    @Override
    public int split_index() {
        return this.split_index;
    }

    @Override
    public int split_cond() {
        return Float.floatToIntBits(this.split_condition);
    }

    @Override
    public float leaf_value() {
        return this.split_condition;
    }

    public BitSet get_split_categories() {
        return this.split_categories;
    }

    void set_split_categories(BitSet split_categories) {
        this.split_categories = split_categories;
    }
}

