/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class ArrayUtils {
    public static double[] nanArray(int len) {
        double[] arr = new double[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = Double.NaN;
        }
        return arr;
    }

    public static double l2norm(double[] x) {
        return Math.sqrt(ArrayUtils.l2norm2(x));
    }

    public static double l2norm2(double[] x) {
        return ArrayUtils.l2norm2(x, false);
    }

    public static double l2norm2(double[] x, boolean skipLast) {
        int last = x.length - (skipLast ? 1 : 0);
        double sum = 0.0;
        for (int i = 0; i < last; ++i) {
            sum += x[i] * x[i];
        }
        return sum;
    }

    public static double[] flat(double[][] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return null;
        }
        int tlen = 0;
        for (double[] t : arr) {
            tlen += t != null ? t.length : 0;
        }
        double[] result = Arrays.copyOf(arr[0], tlen);
        int j = arr[0].length;
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] == null) continue;
            System.arraycopy(arr[i], 0, result, j, arr[i].length);
            j += arr[i].length;
        }
        return result;
    }

    public static double[] eleDiff(double[] from) {
        int arryLen = from.length - 1;
        double[] cumsumR = new double[arryLen];
        for (int index = 0; index < arryLen; ++index) {
            cumsumR[index] = from[index + 1] - from[index];
        }
        return cumsumR;
    }

    public static int[] subtract(int[] from, int val) {
        int arryLen = from.length;
        int[] cumsumR = new int[arryLen];
        for (int index = 0; index < arryLen; ++index) {
            cumsumR[index] = from[index] - val;
        }
        return cumsumR;
    }

    public static int[] subtract(int[] from, int[] val) {
        int arryLen = from.length;
        int[] cumsumR = new int[arryLen];
        for (int index = 0; index < arryLen; ++index) {
            cumsumR[index] = from[index] - val[index];
        }
        return cumsumR;
    }

    public static boolean isBoolColumn(String[] domains) {
        if (domains != null) {
            if (domains.length == 2) {
                if (domains[0].equalsIgnoreCase("true") && domains[1].equalsIgnoreCase("false")) {
                    return true;
                }
                if (domains[1].equalsIgnoreCase("true") && domains[0].equalsIgnoreCase("false")) {
                    return true;
                }
            } else if (domains.length == 1 && (domains[0].equalsIgnoreCase("true") || domains[0].equalsIgnoreCase("false"))) {
                return true;
            }
        }
        return false;
    }

    public static int maxIndex(double[] from, Random rand) {
        assert (rand != null);
        int result = 0;
        int maxCount = 0;
        for (int i = 1; i < from.length; ++i) {
            if (from[i] > from[result]) {
                result = i;
                maxCount = 1;
                continue;
            }
            if (from[i] != from[result] || rand.nextInt(++maxCount) != 0) continue;
            result = i;
        }
        return result;
    }

    public static int maxIndex(double[] from) {
        int result = 0;
        for (int i = 1; i < from.length; ++i) {
            if (!(from[i] > from[result])) continue;
            result = i;
        }
        return result;
    }

    public static void sort(int[] idxs, double[] values) {
        ArrayUtils.sort(idxs, values, 500);
    }

    public static void sort(int[] idxs, final double[] values, int cutoff) {
        if (idxs.length < cutoff) {
            for (int i = 0; i < idxs.length; ++i) {
                for (int j = i; j > 0 && values[idxs[j - 1]] > values[idxs[j]]; --j) {
                    int tmp = idxs[j];
                    idxs[j] = idxs[j - 1];
                    idxs[j - 1] = tmp;
                }
            }
        } else {
            int i;
            Integer[] d = new Integer[idxs.length];
            for (i = 0; i < idxs.length; ++i) {
                d[i] = idxs[i];
            }
            Arrays.sort(d, new Comparator<Integer>(){

                @Override
                public int compare(Integer x, Integer y) {
                    return values[x] < values[y] ? -1 : (values[x] > values[y] ? 1 : 0);
                }
            });
            for (i = 0; i < idxs.length; ++i) {
                idxs[i] = d[i];
            }
        }
    }

    public static void sort(int[] idxs, float[] values, int fromIndex, int toIndex, boolean abs, int increasing) {
        ArrayUtils.sort(idxs, values, fromIndex, toIndex, abs, increasing, 500);
    }

    public static void sort(int[] idxs, final float[] values, int fromIndex, int toIndex, final boolean abs, final int increasing, int cutoff) {
        assert (toIndex > fromIndex) : "toIndex must be > fromIndex";
        if (toIndex - fromIndex < cutoff) {
            block0: for (int i = fromIndex; i < toIndex; ++i) {
                for (int j = i; j > fromIndex; --j) {
                    float f = (abs ? Math.abs(values[idxs[j - 1]]) : values[idxs[j - 1]]) * (float)increasing;
                    float f2 = abs ? Math.abs(values[idxs[j]]) : values[idxs[j]];
                    if (!(f > f2 * (float)increasing)) continue block0;
                    int tmp = idxs[j];
                    idxs[j] = idxs[j - 1];
                    idxs[j - 1] = tmp;
                }
            }
        } else {
            int i;
            Integer[] d = new Integer[idxs.length];
            for (i = 0; i < idxs.length; ++i) {
                d[i] = idxs[i];
            }
            Arrays.sort(d, fromIndex, toIndex, new Comparator<Integer>(){

                @Override
                public int compare(Integer x, Integer y) {
                    return Float.compare((abs ? Math.abs(values[x]) : values[x]) * (float)increasing, (abs ? Math.abs(values[y]) : values[y]) * (float)increasing);
                }
            });
            for (i = 0; i < idxs.length; ++i) {
                idxs[i] = d[i];
            }
        }
    }

    public static String[] append(String[] a, String ... b) {
        if (a == null) {
            return b;
        }
        String[] tmp = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, tmp, a.length, b.length);
        return tmp;
    }

    public static String[][] append(String[][] a, String[] ... b) {
        if (a == null) {
            return b;
        }
        String[][] tmp = (String[][])Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, tmp, a.length, b.length);
        return tmp;
    }

    public static int[] append(int[] a, int ... b) {
        if (a == null) {
            return b;
        }
        int[] tmp = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, tmp, a.length, b.length);
        return tmp;
    }

    public static double[] signum(double[] array) {
        double[] signArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            signArray[i] = array[i] > 0.0 ? 1.0 : (array[i] < 0.0 ? -1.0 : 0.0);
        }
        return signArray;
    }

    public static double[] difference(double[] array) {
        double[] difference = new double[array.length - 1];
        for (int i = 0; i < array.length - 1; ++i) {
            difference[i] = array[i + 1] - array[i];
        }
        return difference;
    }

    public static void multArray(double[] a, double[][] bT, double[] result) {
        int resultDim = result.length;
        int vectorSize = a.length;
        Arrays.fill(result, 0.0);
        for (int index = 0; index < resultDim; ++index) {
            for (int innerIndex = 0; innerIndex < vectorSize; ++innerIndex) {
                int n = index;
                result[n] = result[n] + a[innerIndex] * bT[index][innerIndex];
            }
        }
    }

    public static int[] range(int start, int end) {
        int[] r = new int[end - start + 1];
        for (int i = 0; i < r.length; ++i) {
            r[i] = i + start;
        }
        return r;
    }

    public static double subAndMul(double[] data, double[] p, double[] n) {
        double res = 0.0;
        for (int col = 0; col < data.length; ++col) {
            res += (data[col] - p[col]) * n[col];
        }
        return res;
    }
}

