/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.utils.ArrayUtils;
import java.util.Arrays;

public class ContributionComposer {
    public final int[] composeContributions(int[] contribNameIds, float[] contribs, int topN, int bottomN, boolean compareAbs) {
        assert (contribNameIds.length == contribs.length) : "contribNameIds must have the same length as contribs";
        if (this.returnOnlyTopN(topN, bottomN)) {
            return this.composeSortedContributions(contribNameIds, contribs, topN, compareAbs, -1);
        }
        if (this.returnOnlyBottomN(topN, bottomN)) {
            return this.composeSortedContributions(contribNameIds, contribs, bottomN, compareAbs, 1);
        }
        if (this.returnAllTopN(topN, bottomN, contribs.length)) {
            return this.composeSortedContributions(contribNameIds, contribs, contribs.length, compareAbs, -1);
        }
        this.composeSortedContributions(contribNameIds, contribs, contribNameIds.length, compareAbs, -1);
        int[] bottomSorted = Arrays.copyOfRange(contribNameIds, contribNameIds.length - 1 - bottomN, contribNameIds.length);
        this.reverse(bottomSorted, contribs, bottomSorted.length - 1);
        int[] contribNameIdsTmp = Arrays.copyOf(contribNameIds, topN);
        return ArrayUtils.append(contribNameIdsTmp, bottomSorted);
    }

    private boolean returnOnlyTopN(int topN, int bottomN) {
        return topN != 0 && bottomN == 0;
    }

    private boolean returnOnlyBottomN(int topN, int bottomN) {
        return topN == 0 && bottomN != 0;
    }

    private boolean returnAllTopN(int topN, int bottomN, int len) {
        return topN + bottomN >= len || topN < 0 || bottomN < 0;
    }

    public int checkAndAdjustInput(int n, int len) {
        if (n < 0 || n > len) {
            return len;
        }
        return n;
    }

    private int[] composeSortedContributions(int[] contribNameIds, float[] contribs, int n, boolean compareAbs, int increasing) {
        int nAdjusted = this.checkAndAdjustInput(n, contribs.length);
        this.sortContributions(contribNameIds, contribs, compareAbs, increasing);
        if (nAdjusted < contribs.length) {
            int bias = contribNameIds[contribs.length - 1];
            int[] contribNameIdsSorted = Arrays.copyOfRange(contribNameIds, 0, nAdjusted + 1);
            contribNameIdsSorted[nAdjusted] = bias;
            return contribNameIdsSorted;
        }
        return contribNameIds;
    }

    private void sortContributions(int[] contribNameIds, float[] contribs, boolean compareAbs, int increasing) {
        ArrayUtils.sort(contribNameIds, contribs, 0, contribs.length - 1, compareAbs, increasing);
    }

    private void reverse(int[] contribNameIds, float[] contribs, int len) {
        for (int i = 0; i < len / 2; ++i) {
            if (contribs[contribNameIds[i]] == contribs[contribNameIds[len - i - 1]]) continue;
            int tmp = contribNameIds[i];
            contribNameIds[i] = contribNameIds[len - i - 1];
            contribNameIds[len - i - 1] = tmp;
        }
    }
}

