/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.targetencoder;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.targetencoder.ColumnsMapping;
import hex.genmodel.algos.targetencoder.ColumnsToSingleMapping;
import hex.genmodel.algos.targetencoder.EncodingMap;
import hex.genmodel.algos.targetencoder.EncodingMaps;
import hex.genmodel.algos.targetencoder.TargetEncoderMojoModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TargetEncoderMojoReader
extends ModelMojoReader<TargetEncoderMojoModel> {
    public static final String ENCODING_MAP_PATH = "feature_engineering/target_encoding/encoding_map.ini";
    public static final String MISSING_VALUES_PRESENCE_MAP_PATH = "feature_engineering/target_encoding/te_column_name_to_missing_values_presence.ini";
    public static final String INPUT_ENCODING_COLUMNS_MAPPING_PATH = "feature_engineering/target_encoding/input_encoding_columns_map.ini";
    public static final String INPUT_OUTPUT_COLUMNS_MAPPING_PATH = "feature_engineering/target_encoding/input_output_columns_map.ini";

    @Override
    public String getModelName() {
        return "TargetEncoder";
    }

    @Override
    protected void readModelData() throws IOException {
        ((TargetEncoderMojoModel)this._model)._keepOriginalCategoricalColumns = this.readkv("keep_original_categorical_columns", false);
        ((TargetEncoderMojoModel)this._model)._withBlending = (Boolean)this.readkv("with_blending");
        if (((TargetEncoderMojoModel)this._model)._withBlending) {
            ((TargetEncoderMojoModel)this._model)._inflectionPoint = (Double)this.readkv("inflection_point");
            ((TargetEncoderMojoModel)this._model)._smoothing = (Double)this.readkv("smoothing");
        }
        ((TargetEncoderMojoModel)this._model)._nonPredictors = Arrays.asList(this.readkv("non_predictors", "").split(";"));
        ((TargetEncoderMojoModel)this._model).setEncodings(this.parseEncodingMap());
        ((TargetEncoderMojoModel)this._model)._teColumn2HasNAs = this.parseTEColumnsToHasNAs();
        ((TargetEncoderMojoModel)this._model)._inencMapping = this.parseInEncColumnsMapping(INPUT_ENCODING_COLUMNS_MAPPING_PATH);
        ((TargetEncoderMojoModel)this._model)._inoutMapping = this.parseInOutColumnsMapping(INPUT_OUTPUT_COLUMNS_MAPPING_PATH);
        ((TargetEncoderMojoModel)this._model).init();
    }

    @Override
    protected TargetEncoderMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new TargetEncoderMojoModel(columns, domains, responseColumn);
    }

    private Map<String, Boolean> parseTEColumnsToHasNAs() throws IOException {
        HashMap<String, Boolean> cols2HasNAs = new HashMap<String, Boolean>();
        if (this.exists(MISSING_VALUES_PRESENCE_MAP_PATH)) {
            Iterable<String> parsedFile = this.readtext(MISSING_VALUES_PRESENCE_MAP_PATH);
            for (String line : parsedFile) {
                String[] indexAndPresence = line.split("\\s*=\\s*", 2);
                cols2HasNAs.put(indexAndPresence[0], Integer.parseInt(indexAndPresence[1]) == 1);
            }
        }
        return cols2HasNAs;
    }

    protected EncodingMaps parseEncodingMap() throws IOException {
        if (!this.exists(ENCODING_MAP_PATH)) {
            return null;
        }
        HashMap<String, EncodingMap> encodingMaps = new HashMap<String, EncodingMap>();
        try (BufferedReader source = this.getMojoReaderBackend().getTextFile(ENCODING_MAP_PATH);){
            EncodingMap colEncodingMap = new EncodingMap(((TargetEncoderMojoModel)this._model).nclasses());
            String sectionName = null;
            while (true) {
                String line;
                if ((line = source.readLine()) == null) {
                    encodingMaps.put(sectionName, colEncodingMap);
                    break;
                }
                line = line.trim();
                String matchSection = this.matchNewSection(line);
                if (sectionName == null || matchSection != null) {
                    if (sectionName != null) {
                        encodingMaps.put(sectionName, colEncodingMap);
                    }
                    sectionName = matchSection;
                    colEncodingMap = new EncodingMap(((TargetEncoderMojoModel)this._model).nclasses());
                    continue;
                }
                String[] res = line.split("\\s*=\\s*", 2);
                double[] components = this.processEncodingsComponents(res[1].split(" "));
                colEncodingMap.add(Integer.parseInt(res[0]), components);
            }
        }
        return new EncodingMaps(encodingMaps);
    }

    private List<ColumnsMapping> parseInOutColumnsMapping(String fileName) throws IOException {
        ArrayList<ColumnsMapping> mapping = new ArrayList<ColumnsMapping>();
        for (List<String>[] entry : this.parseColumnsMapping(fileName)) {
            mapping.add(new ColumnsMapping(entry[0].toArray(new String[0]), entry[1].toArray(new String[0])));
        }
        return mapping;
    }

    private List<ColumnsToSingleMapping> parseInEncColumnsMapping(String fileName) throws IOException {
        ArrayList<ColumnsToSingleMapping> mapping = new ArrayList<ColumnsToSingleMapping>();
        for (List<String>[] entry : this.parseColumnsMapping(fileName)) {
            mapping.add(new ColumnsToSingleMapping(entry[0].toArray(new String[0]), entry[1].get(0), entry[2] == null ? null : entry[2].toArray(new String[0])));
        }
        return mapping;
    }

    private List<List<String>[]> parseColumnsMapping(String fileName) throws IOException {
        ArrayList<List<String>[]> mapping = new ArrayList<List<String>[]>();
        if (this.exists(fileName)) {
            ArrayList<String> from = null;
            ArrayList<String> to = null;
            ArrayList<String> toDomain = null;
            for (String line : this.readtext(fileName)) {
                if ("[from]".equals(line)) {
                    if (from != null && to != null) {
                        mapping.add(new List[]{from, to, toDomain});
                    }
                    from = new ArrayList<String>();
                    to = null;
                    toDomain = null;
                    continue;
                }
                if ("[to]".equals(line)) {
                    to = new ArrayList<String>();
                    continue;
                }
                if ("[to_domain]".equals(line)) {
                    toDomain = new ArrayList<String>();
                    continue;
                }
                if (toDomain != null) {
                    toDomain.add(line);
                    continue;
                }
                if (to != null) {
                    to.add(line);
                    continue;
                }
                from.add(line);
            }
            if (from != null && to != null) {
                mapping.add(new List[]{from, to, toDomain});
            }
        }
        return mapping;
    }

    private String matchNewSection(String line) {
        Pattern pattern = Pattern.compile("\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private double[] processEncodingsComponents(String[] componentsStr) {
        double[] numDen = new double[componentsStr.length];
        int i = 0;
        for (String str : componentsStr) {
            numDen[i] = Double.parseDouble(str);
            ++i;
        }
        return numDen;
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

