/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

public class GamUtilsThinPlateRegression {
    public static double calTPConstantTerm(int m, int d, boolean dEven) {
        if (dEven) {
            return Math.pow(-1.0, (double)(m + 1) + (double)d / 2.0) / (Math.pow(2.0, 2 * m - 1) * Math.pow(Math.PI, (double)d / 2.0) * (double)GamUtilsThinPlateRegression.factorial(m - 1) * (double)GamUtilsThinPlateRegression.factorial(m - d / 2));
        }
        return Math.pow(-1.0, m) * (double)m / ((double)GamUtilsThinPlateRegression.factorial(2 * m) * Math.pow(Math.PI, (double)(d - 1) / 2.0));
    }

    public static int factorial(int m) {
        if (m <= 1) {
            return 1;
        }
        int prod = 1;
        for (int index = 1; index <= m; ++index) {
            prod *= index;
        }
        return prod;
    }

    public static void calculateDistance(double[] rowValues, double[] chk, int knotNum, double[][] knots, int d, int m, boolean dEven, double constantTerms, double[] oneOGamColStd, boolean standardizeGAM) {
        for (int knotInd = 0; knotInd < knotNum; ++knotInd) {
            double sumSq = 0.0;
            for (int predInd = 0; predInd < d; ++predInd) {
                double temp = standardizeGAM ? (chk[predInd] - knots[predInd][knotInd]) * oneOGamColStd[predInd] : chk[predInd] - knots[predInd][knotInd];
                sumSq += temp * temp;
            }
            double distance = Math.pow(Math.sqrt(sumSq), 2 * m - d);
            rowValues[knotInd] = constantTerms * distance;
            if (!dEven || distance == 0.0) continue;
            int n = knotInd;
            rowValues[n] = rowValues[n] * Math.log(distance);
        }
    }

    public static void calculatePolynomialBasis(double[] onePolyRow, double[] oneDataRow, int d, int M, int[][] polyBasisList, double[] gamColMean, double[] oneOGamStd, boolean standardizeGAM) {
        for (int colIndex = 0; colIndex < M; ++colIndex) {
            int[] oneBasis = polyBasisList[colIndex];
            double val = 1.0;
            for (int predIndex = 0; predIndex < d; ++predIndex) {
                val *= standardizeGAM ? Math.pow(oneDataRow[predIndex] - gamColMean[predIndex] * oneOGamStd[predIndex], oneBasis[predIndex]) : Math.pow(oneDataRow[predIndex], oneBasis[predIndex]);
            }
            onePolyRow[colIndex] = val;
        }
    }
}

