/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.ensemble;

import hex.genmodel.MojoModel;
import java.io.Serializable;

public class StackedEnsembleMojoModel
extends MojoModel {
    MojoModel _metaLearner;
    boolean _useLogitMetaLearnerTransform;
    StackedEnsembleMojoSubModel[] _baseModels;
    int _baseModelNum;

    public StackedEnsembleMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    private static double logit(double p) {
        double x = p / (1.0 - p);
        return x == 0.0 ? -19.0 : Math.max(-19.0, Math.log(x));
    }

    private static void logitTransformRow(double[] basePreds) {
        for (int i = 0; i < basePreds.length; ++i) {
            basePreds[i] = StackedEnsembleMojoModel.logit(Math.min(0.999999999, Math.max(basePreds[i], 1.0E-9)));
        }
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        double[] basePreds = new double[this._baseModelNum];
        double[] basePredsRow = new double[preds.length];
        if (this._nclasses > 2) {
            basePreds = new double[this._baseModelNum * this._nclasses];
            for (int i = 0; i < this._baseModelNum; ++i) {
                if (this._baseModels[i] == null) continue;
                for (int j = 0; j < this._nclasses; ++j) {
                    basePreds[i * this._nclasses + j] = this._baseModels[i]._mojoModel.score0(this._baseModels[i].remapRow(row), basePredsRow)[j + 1];
                }
            }
            if (this._useLogitMetaLearnerTransform) {
                StackedEnsembleMojoModel.logitTransformRow(basePreds);
            }
        } else if (this._nclasses == 2) {
            for (int i = 0; i < this._baseModelNum; ++i) {
                if (this._baseModels[i] == null) continue;
                this._baseModels[i]._mojoModel.score0(this._baseModels[i].remapRow(row), basePredsRow);
                basePreds[i] = basePredsRow[2];
            }
            if (this._useLogitMetaLearnerTransform) {
                StackedEnsembleMojoModel.logitTransformRow(basePreds);
            }
        } else {
            for (int i = 0; i < this._baseModelNum; ++i) {
                if (this._baseModels[i] == null) continue;
                this._baseModels[i]._mojoModel.score0(this._baseModels[i].remapRow(row), basePredsRow);
                basePreds[i] = basePredsRow[0];
            }
        }
        this._metaLearner.score0(basePreds, preds);
        return preds;
    }

    static class StackedEnsembleMojoSubModel
    implements Serializable {
        final MojoModel _mojoModel;
        final int[] _mapping;

        public StackedEnsembleMojoSubModel(MojoModel mojoModel, int[] mapping) {
            this._mojoModel = mojoModel;
            this._mapping = mapping;
        }

        public double[] remapRow(double[] row) {
            double[] remappedRow = new double[this._mapping.length];
            for (int i = 0; i < this._mapping.length; ++i) {
                remappedRow[i] = row[this._mapping[i]];
            }
            return remappedRow;
        }
    }
}

