/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent;

import java.util.List;
import net.razorvine.serpent.ast.BigIntNode;
import net.razorvine.serpent.ast.BooleanNode;
import net.razorvine.serpent.ast.BytesNode;
import net.razorvine.serpent.ast.ComplexNumberNode;
import net.razorvine.serpent.ast.DictNode;
import net.razorvine.serpent.ast.DoubleNode;
import net.razorvine.serpent.ast.INode;
import net.razorvine.serpent.ast.INodeVisitor;
import net.razorvine.serpent.ast.IntegerNode;
import net.razorvine.serpent.ast.KeyValueNode;
import net.razorvine.serpent.ast.ListNode;
import net.razorvine.serpent.ast.LongNode;
import net.razorvine.serpent.ast.NoneNode;
import net.razorvine.serpent.ast.SetNode;
import net.razorvine.serpent.ast.StringNode;
import net.razorvine.serpent.ast.TupleNode;

public class DebugVisitor
implements INodeVisitor {
    private StringBuilder result = new StringBuilder();
    private int indentlevel = 0;

    public String toString() {
        return this.result.toString();
    }

    protected void indent() {
        for (int i = 0; i < this.indentlevel; ++i) {
            this.result.append("    ");
        }
    }

    @Override
    public void visit(ComplexNumberNode complex) {
        this.result.append(String.format("complexnumber (%sr,%si)", complex.real, complex.imaginary));
    }

    @Override
    public void visit(DictNode dict) {
        this.result.append("(dict\n");
        ++this.indentlevel;
        for (INode e : dict.elements) {
            this.indent();
            KeyValueNode kv = (KeyValueNode)e;
            kv.key.accept(this);
            this.result.append(" = ");
            kv.value.accept(this);
            this.result.append(",\n");
        }
        --this.indentlevel;
        this.indent();
        this.result.append(")");
    }

    @Override
    public void visit(ListNode list) {
        this.result.append("(list\n");
        ++this.indentlevel;
        for (INode node : list.elements) {
            this.indent();
            node.accept(this);
            this.result.append(",\n");
        }
        --this.indentlevel;
        this.indent();
        this.result.append(")");
    }

    @Override
    public void visit(NoneNode none) {
        this.result.append("None");
    }

    @Override
    public void visit(IntegerNode value) {
        this.result.append(String.format("int %s", value.value));
    }

    @Override
    public void visit(BigIntNode value) {
        this.result.append(String.format("bigint %s", value.value));
    }

    @Override
    public void visit(LongNode value) {
        this.result.append(String.format("long %s", value.value));
    }

    @Override
    public void visit(DoubleNode value) {
        this.result.append(String.format("double %s", value.value));
    }

    @Override
    public void visit(BooleanNode value) {
        this.result.append(String.format("bool %s", value.value));
    }

    @Override
    public void visit(StringNode value) {
        this.result.append(String.format("string '%s'", value.value));
    }

    @Override
    public void visit(BytesNode value) {
        this.result.append(String.format("bytes %s", ((List)value.value).toString()));
    }

    @Override
    public void visit(SetNode setnode) {
        this.result.append("(set\n");
        ++this.indentlevel;
        for (INode node : setnode.elements) {
            this.indent();
            node.accept(this);
            this.result.append(",\n");
        }
        --this.indentlevel;
        this.indent();
        this.result.append(")");
    }

    @Override
    public void visit(TupleNode tuple) {
        this.result.append("(tuple\n");
        ++this.indentlevel;
        for (INode node : tuple.elements) {
            this.indent();
            node.accept(this);
            this.result.append(",\n");
        }
        --this.indentlevel;
        this.indent();
        this.result.append(")");
    }
}

