/*
 * Decompiled with CFR 0.152.
 */
package optbinning;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import optbinning.Binning;
import optbinning.BinningUtil;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Initializer;
import sklearn.InitializerUtil;

public class BinningProcess
extends Initializer {
    public BinningProcess(String module, String name) {
        super(module, name);
    }

    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        return this.encodeFeatures(Collections.emptyList(), encoder);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Boolean> support = this.getSupport();
        Map<String, Binning> binnedVariables = this.getBinnedVariables();
        List<String> variableNames = this.getVariableNames();
        Map<String, String> variableDTypes = this.getVariableDTypes();
        Map<String, Map<String, ?>> variableStats = this.getVariableStats();
        ClassDictUtil.checkSize((Collection[])new Collection[]{support, variableNames, variableDTypes.values(), variableStats.values()});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < support.size(); ++i) {
            DerivedField derivedField;
            String dtype;
            boolean flag = support.get(i);
            if (!flag) continue;
            String variableName = variableNames.get(i);
            Binning binning = binnedVariables.get(variableName);
            switch (dtype = binning.getDType()) {
                case "numerical": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(dtype);
                }
            }
            List<Number> splits = binning.getSplitsOptimal();
            List<? extends Number> categories = binning.getCategories();
            Feature feature = InitializerUtil.selectFeature((String)variableName, features, (SkLearnEncoder)encoder);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            if (!splits.isEmpty()) {
                BinningUtil.checkIncreasingOrder(splits);
                Discretize discretize = new Discretize(continuousFeature.getName()).setMapMissingTo((Object)0.0);
                for (int j = 0; j <= splits.size(); ++j) {
                    Number leftMargin = null;
                    Number rightMargin = null;
                    if (j == 0) {
                        rightMargin = splits.get(j);
                    } else if (j == splits.size()) {
                        leftMargin = splits.get(j - 1);
                    } else {
                        leftMargin = splits.get(j - 1);
                        rightMargin = splits.get(j);
                    }
                    Interval interval = new Interval(Interval.Closure.CLOSED_OPEN).setLeftMargin(leftMargin).setRightMargin(rightMargin);
                    DiscretizeBin discretizeBin = new DiscretizeBin((Object)categories.get(j), interval);
                    discretize.addDiscretizeBins(new DiscretizeBin[]{discretizeBin});
                }
                derivedField = encoder.createDerivedField(this.createFieldName("optBinning", new Object[]{continuousFeature}), OpType.CATEGORICAL, DataType.DOUBLE, (Expression)discretize);
                feature = new CategoricalFeature((PMMLEncoder)encoder, (Field)derivedField, categories.subList(0, splits.size() + 2));
            } else {
                Apply expression = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{continuousFeature.ref()}), PMMLUtil.createConstant((Object)categories.get(0), null), PMMLUtil.createConstant((Number)0.0)});
                derivedField = encoder.createDerivedField(this.createFieldName("optBinning", new Object[]{continuousFeature}), OpType.CATEGORICAL, DataType.DOUBLE, (Expression)expression);
                feature = new CategoricalFeature((PMMLEncoder)encoder, (Field)derivedField, categories.subList(0, 1));
            }
            result.add(feature);
        }
        return result;
    }

    public Map<String, Binning> getBinnedVariables() {
        Map binnedVariables = this.getDict("_binned_variables");
        CastFunction<Binning> castFunction = new CastFunction<Binning>(Binning.class){

            protected String formatMessage(Object object) {
                return "The binning object (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Binning";
            }
        };
        return Maps.transformValues((Map)binnedVariables, (Function)castFunction);
    }

    public List<Boolean> getSupport() {
        return this.getArray("_support", Boolean.class);
    }

    public List<String> getVariableNames() {
        return this.getListLike("variable_names", String.class);
    }

    public Map<String, String> getVariableDTypes() {
        return this.getDict("_variable_dtypes");
    }

    public Map<String, Map<String, ?>> getVariableStats() {
        return this.getDict("_variable_stats");
    }
}

