/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.MapValues;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ThresholdFeature;
import org.jpmml.converter.TypeUtil;
import org.jpmml.model.ToStringHelper;

public class MapFeature
extends ThresholdFeature {
    private Map<?, ? extends Number> mapping = null;
    private Object missingCategory = null;
    private Number defaultValue = null;

    public MapFeature(PMMLEncoder encoder, Field<?> field, Map<?, ? extends Number> mapping, Object missingCategory, Number defaultValue) {
        this(encoder, field.requireName(), field.requireDataType(), mapping, missingCategory, defaultValue);
    }

    public MapFeature(PMMLEncoder encoder, Feature feature, Map<?, ? extends Number> mapping, Object missingCategory, Number defaultValue) {
        this(encoder, feature.getName(), feature.getDataType(), mapping, missingCategory, defaultValue);
    }

    public MapFeature(PMMLEncoder encoder, String name, DataType dataType, Map<?, ? extends Number> mapping, Object missingCategory, Number defaultValue) {
        super(encoder, name, dataType);
        this.setMapping(mapping);
        this.setMissingCategory(missingCategory);
        this.setDefaultValue(defaultValue);
    }

    public String getDerivedName() {
        return FieldNameUtil.create((String)"map", (Object[])new Object[]{this.getName()});
    }

    public ContinuousFeature toContinuousFeature() {
        String name = this.getName();
        Map<?, Number> mapping = this.getMapping();
        Object missingCategory = this.getMissingCategory();
        Number defaultValue = this.getDefaultValue();
        Supplier<Expression> expressionSupplier = () -> {
            LinkedHashMap validMapping = new LinkedHashMap(mapping);
            Number mapMissingTo = (Number)validMapping.remove(missingCategory);
            MapValues mapValues = PMMLUtil.createMapValues((String)name, validMapping).setMapMissingTo((Object)mapMissingTo).setDefaultValue((Object)defaultValue);
            return mapValues;
        };
        DataType dataType = TypeUtil.getDataType(mapping.values(), (DataType)DataType.DOUBLE);
        return this.toContinuousFeature(this.getDerivedName(), dataType, expressionSupplier);
    }

    public Set<?> getValues(Predicate<Number> predicate) {
        Map<?, Number> mapping = this.getMapping();
        Number defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet result = new LinkedHashSet();
        Set<Map.Entry<?, Number>> entries = mapping.entrySet();
        entries.stream().filter(entry -> predicate.test((Number)entry.getValue())).map(entry -> entry.getKey()).forEach(result::add);
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.getMapping());
        result = 31 * result + Objects.hash(this.getMissingCategory());
        result = 31 * result + Objects.hash(this.getDefaultValue());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof MapFeature) {
            MapFeature that = (MapFeature)((Object)object);
            return super.equals(object) && Objects.equals(this.getMapping(), that.getMapping()) && Objects.equals(this.getMissingCategory(), that.getMissingCategory()) && Objects.equals(this.getDefaultValue(), that.getDefaultValue());
        }
        return false;
    }

    protected ToStringHelper toStringHelper() {
        return new ToStringHelper((Object)this).add("mapping", this.getMapping()).add("missingCategory", this.getMissingCategory()).add("defaultValue", (Object)this.getDefaultValue());
    }

    public Map<?, ? extends Number> getMapping() {
        return this.mapping;
    }

    private void setMapping(Map<?, ? extends Number> mapping) {
        this.mapping = Objects.requireNonNull(mapping);
    }

    public Object getMissingValue() {
        return this.getMissingCategory();
    }

    public Object getMissingCategory() {
        return this.missingCategory;
    }

    private void setMissingCategory(Object missingCategory) {
        this.missingCategory = missingCategory;
    }

    public Number getDefaultValue() {
        return this.defaultValue;
    }

    private void setDefaultValue(Number defaultValue) {
        this.defaultValue = defaultValue;
    }
}

