/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMML;
import org.dmg.pmml.UnivariateStats;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.visitors.FeatureExpander;
import org.jpmml.converter.visitors.ModelCleanerBattery;
import org.jpmml.converter.visitors.PMMLCleanerBattery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelEncoder
extends PMMLEncoder {
    private List<Model> transformers = new ArrayList<Model>();
    private Map<Model, ListMultimap<String, Decorator>> decorators = new LinkedHashMap<Model, ListMultimap<String, Decorator>>();
    private Map<Model, ListMultimap<Feature, Number>> featureImportances = new LinkedHashMap<Model, ListMultimap<Feature, Number>>();
    private Map<Model, List<UnivariateStats>> univariateStats = new LinkedHashMap<Model, List<UnivariateStats>>();
    private static final Logger logger = LoggerFactory.getLogger(ModelEncoder.class);

    public PMML encodePMML(Model model) {
        List<Model> transformers;
        PMML pmml = this.encodePMML();
        if (model != null) {
            this.transferContent(null, model);
        }
        if (!(transformers = this.getTransformers()).isEmpty()) {
            ArrayList<Model> models = new ArrayList<Model>(transformers);
            if (model != null) {
                models.add(model);
            }
            MiningModel miningModel = MiningModelUtil.createModelChain(models);
            this.transferUnivariateStats(model, (Model)miningModel);
            model = miningModel;
        }
        if (model != null) {
            pmml.addModels(new Model[]{model});
            ModelCleanerBattery modelCleanerBattery = new ModelCleanerBattery();
            modelCleanerBattery.applyTo((Visitable)pmml);
            this.encodeDecorators(pmml);
            this.encodeFeatureImportances(pmml);
            this.encodeUnivariateStats(pmml);
        }
        PMMLCleanerBattery pmmlCleanerBattery = new PMMLCleanerBattery();
        pmmlCleanerBattery.applyTo((Visitable)pmml);
        return pmml;
    }

    public List<Model> getTransformers() {
        return this.transformers;
    }

    public void addTransformer(Model transformer) {
        this.transformers.add(transformer);
    }

    public Map<Model, ListMultimap<String, Decorator>> getDecorators() {
        return this.decorators;
    }

    public void addDecorator(Field<?> field, Decorator decorator) {
        this.addDecorator(null, field, decorator);
    }

    public void addDecorator(Model model, Field<?> field, Decorator decorator) {
        Map<Model, ListMultimap<String, Decorator>> modelDecorators = this.getDecorators();
        ArrayListMultimap decorators = modelDecorators.get(model);
        if (decorators == null) {
            decorators = ArrayListMultimap.create();
            modelDecorators.put(model, (ListMultimap<String, Decorator>)decorators);
        }
        decorators.put((Object)field.requireName(), (Object)decorator);
    }

    public Map<Model, ListMultimap<Feature, Number>> getFeatureImportances() {
        return this.featureImportances;
    }

    public void addFeatureImportance(Feature feature, Number importance) {
        this.addFeatureImportance(null, feature, importance);
    }

    public void addFeatureImportance(Model model, Feature feature, Number importance) {
        Map<Model, ListMultimap<Feature, Number>> modelFeatureImportances = this.getFeatureImportances();
        ArrayListMultimap featureImportances = modelFeatureImportances.get(model);
        if (featureImportances == null) {
            featureImportances = ArrayListMultimap.create();
            modelFeatureImportances.put(model, (ListMultimap<Feature, Number>)featureImportances);
        }
        featureImportances.put((Object)feature, (Object)importance);
    }

    public Map<Model, List<UnivariateStats>> getUnivariateStats() {
        return this.univariateStats;
    }

    public void addUnivariateStats(UnivariateStats pmmlUnivariateStats) {
        this.addUnivariateStats(null, pmmlUnivariateStats);
    }

    public void addUnivariateStats(Model model, UnivariateStats pmmlUnivariateStats) {
        Map<Model, List<UnivariateStats>> modelUnivariateStats = this.getUnivariateStats();
        List<UnivariateStats> univariateStats = modelUnivariateStats.get(model);
        if (univariateStats == null) {
            univariateStats = new ArrayList<UnivariateStats>();
            modelUnivariateStats.put(model, univariateStats);
        }
        univariateStats.add(pmmlUnivariateStats);
    }

    public void transferContent(Model left, Model right) {
        this.transferDecorators(left, right);
        this.transferFeatureImportances(left, right);
        this.transferUnivariateStats(left, right);
    }

    public void transferDecorators(Model left, Model right) {
        ModelEncoder.transferValue(this.decorators, left, right);
    }

    public void transferFeatureImportances(Model left, Model right) {
        ModelEncoder.transferValue(this.featureImportances, left, right);
    }

    public void transferUnivariateStats(Model left, Model right) {
        ModelEncoder.transferValue(this.univariateStats, left, right);
    }

    private void encodeDecorators(PMML pmml) {
        Map<Model, ListMultimap<String, Decorator>> modelDecorators = this.getDecorators();
        if (modelDecorators.isEmpty()) {
            return;
        }
        if (modelDecorators.containsKey(null)) {
            throw new IllegalStateException();
        }
        Set<Map.Entry<Model, ListMultimap<String, Decorator>>> entries = modelDecorators.entrySet();
        for (Map.Entry entry : entries) {
            Model model = (Model)entry.getKey();
            ListMultimap decorators = (ListMultimap)entry.getValue();
            MiningSchema miningSchema = model.requireMiningSchema();
            if (!miningSchema.hasMiningFields()) continue;
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                String fieldName = miningField.getName();
                List fieldDecorators = decorators.get((Object)fieldName);
                if (fieldDecorators == null || fieldDecorators.isEmpty()) continue;
                for (Decorator fieldDecorator : fieldDecorators) {
                    fieldDecorator.decorate(miningField);
                }
            }
        }
    }

    private void encodeFeatureImportances(PMML pmml) {
        Map<Model, ListMultimap<Feature, Number>> modelFeatureImportances = this.getFeatureImportances();
        if (modelFeatureImportances.isEmpty()) {
            return;
        }
        if (modelFeatureImportances.containsKey(null)) {
            throw new IllegalStateException();
        }
        Map<Model, Set<String>> expandableFeatures = modelFeatureImportances.entrySet().stream().collect(Collectors.toMap(entry -> (Model)entry.getKey(), entry -> ((ListMultimap)entry.getValue()).keySet().stream().map(feature -> feature.getName()).collect(Collectors.toSet())));
        FeatureExpander featureExpander = new FeatureExpander(expandableFeatures);
        featureExpander.applyTo((Visitable)pmml);
        Set<Map.Entry<Model, ListMultimap<Feature, Number>>> entries = modelFeatureImportances.entrySet();
        for (Map.Entry entry2 : entries) {
            Model model = (Model)entry2.getKey();
            ListMultimap featureImportances = (ListMultimap)entry2.getValue();
            MathContext mathContext = model.getMathContext();
            Collection featureImportanceEntries = featureImportances.entries();
            Map<String, Set<Field<?>>> featureFields = featureExpander.getExpandedFeatures(model);
            if (featureFields == null) {
                throw new IllegalArgumentException();
            }
            ArrayListMultimap fieldImportances = ArrayListMultimap.create();
            for (Map.Entry featureImportanceEntry : featureImportanceEntries) {
                String name = ((Feature)featureImportanceEntry.getKey()).getName();
                Number importance2 = (Number)featureImportanceEntry.getValue();
                if (ValueUtil.isZero(importance2)) continue;
                Set<Field<?>> fields = featureFields.get(name);
                if (fields == null) {
                    logger.warn("Unused feature '" + (String)name + "' has non-zero importance");
                    continue;
                }
                Number fieldImportance = ValueUtil.divide(mathContext, importance2, fields.size());
                for (Field<?> field : fields) {
                    fieldImportances.put((Object)field.requireName(), (Object)fieldImportance);
                }
            }
            MiningSchema miningSchema = model.requireMiningSchema();
            if (!miningSchema.hasMiningFields()) continue;
            List miningFields = miningSchema.getMiningFields();
            block6: for (MiningField miningField : miningFields) {
                String fieldName = miningField.getName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case ACTIVE: {
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                List fieldImportance = fieldImportances.get((Object)fieldName);
                if (fieldImportance == null || fieldImportance.isEmpty()) continue;
                miningField.setImportance(ValueUtil.sum(mathContext, fieldImportance));
            }
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Number> importances = new ArrayList<Number>();
            for (Map.Entry featureImportanceEntry : featureImportanceEntries) {
                names.add(FeatureUtil.getName((Feature)featureImportanceEntry.getKey()));
                importances.add((Number)featureImportanceEntry.getValue());
            }
            LinkedHashMap<String, ArrayList<Object>> nativeFeatureImportances = new LinkedHashMap<String, ArrayList<Object>>();
            nativeFeatureImportances.put("data:name", names);
            nativeFeatureImportances.put("data:importance", importances);
            List nonZeroImportances = importances.stream().filter(importance -> !ValueUtil.isZero(importance)).collect(Collectors.toList());
            InlineTable inlineTable = PMMLUtil.createInlineTable(nativeFeatureImportances).addExtensions(new Extension[]{PMMLUtil.createExtension("numberOfImportances", String.valueOf(importances.size()))}).addExtensions(new Extension[]{PMMLUtil.createExtension("numberOfNonZeroImportances", String.valueOf(nonZeroImportances.size()))}).addExtensions(new Extension[]{PMMLUtil.createExtension("sumOfImportances", String.valueOf(ValueUtil.sum(mathContext, importances)))});
            if (!nonZeroImportances.isEmpty()) {
                Comparator<Number> comparator = new Comparator<Number>(){

                    @Override
                    public int compare(Number left, Number right) {
                        return Double.compare(left.doubleValue(), right.doubleValue());
                    }
                };
                inlineTable.addExtensions(new Extension[]{PMMLUtil.createExtension("minImportance", String.valueOf(Collections.min(nonZeroImportances, comparator)))}).addExtensions(new Extension[]{PMMLUtil.createExtension("maxImportance", String.valueOf(Collections.max(nonZeroImportances, comparator)))});
            }
            miningSchema.addExtensions(new Extension[]{PMMLUtil.createExtension("X-FeatureImportances", inlineTable)});
        }
    }

    private void encodeUnivariateStats(PMML pmml) {
        Map<Model, List<UnivariateStats>> modelUnivariateStats = this.getUnivariateStats();
        if (modelUnivariateStats.isEmpty()) {
            return;
        }
        if (modelUnivariateStats.containsKey(null)) {
            throw new IllegalStateException();
        }
        Set<Map.Entry<Model, List<UnivariateStats>>> entries = modelUnivariateStats.entrySet();
        for (Map.Entry entry : entries) {
            Model model = (Model)entry.getKey();
            List univariateStats = (List)entry.getValue();
            Map fieldUnivariateStats = univariateStats.stream().collect(Collectors.toMap(UnivariateStats::getField, Function.identity()));
            MiningSchema miningSchema = model.requireMiningSchema();
            if (!miningSchema.hasMiningFields()) continue;
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                String fieldName = miningField.getName();
                UnivariateStats pmmlUnivariateStats = (UnivariateStats)fieldUnivariateStats.get(fieldName);
                if (pmmlUnivariateStats == null) continue;
                ModelStats modelStats = ModelUtil.ensureModelStats(model);
                modelStats.addUnivariateStats(new UnivariateStats[]{pmmlUnivariateStats});
            }
        }
    }

    private static <K, V> void transferValue(Map<K, V> map, K left, K right) {
        V value = map.remove(left);
        if (value != null) {
            map.put(right, value);
        }
    }
}

