/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import com.google.common.primitives.Doubles;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.glm.GlmMojoModel;
import java.lang.reflect.Field;
import java.util.List;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.Label;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.h2o.GlmMojoModelBaseConverter;

public class GlmMojoModelConverter
extends GlmMojoModelBaseConverter<GlmMojoModel> {
    private static final Field FIELD_LINK;

    public GlmMojoModelConverter(GlmMojoModel model) {
        super(model);
    }

    public RegressionModel encodeModel(Schema schema) {
        RegressionModel regressionModel;
        String family;
        RegressionModel.NormalizationMethod normalizationMethod;
        String link;
        GlmMojoModel model = (GlmMojoModel)this.getModel();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        List beta = Doubles.asList((double[])GlmMojoModelConverter.getBeta((MojoModel)model));
        SchemaUtil.checkSize((int)(beta.size() - 1), (List)features);
        List coefficients = beta.subList(0, beta.size() - 1);
        Double intercept = (Double)beta.get(beta.size() - 1);
        switch (link = GlmMojoModelConverter.getLink(model)) {
            case "identity": {
                normalizationMethod = RegressionModel.NormalizationMethod.NONE;
                break;
            }
            case "logit": {
                normalizationMethod = RegressionModel.NormalizationMethod.LOGIT;
                break;
            }
            default: {
                throw new IllegalArgumentException(link);
            }
        }
        switch (family = GlmMojoModelConverter.getFamily((MojoModel)model)) {
            case "binomial": {
                regressionModel = RegressionModelUtil.createBinaryLogisticClassification((List)features, coefficients, (Number)intercept, (RegressionModel.NormalizationMethod)normalizationMethod, (boolean)true, (Schema)schema);
                break;
            }
            case "gaussian": {
                regressionModel = RegressionModelUtil.createRegression((List)features, coefficients, (Number)intercept, (RegressionModel.NormalizationMethod)normalizationMethod, (Schema)schema);
                break;
            }
            default: {
                throw new IllegalArgumentException(family);
            }
        }
        return regressionModel;
    }

    public static String getLink(GlmMojoModel model) {
        return (String)GlmMojoModelConverter.getFieldValue(FIELD_LINK, model);
    }

    static {
        try {
            FIELD_LINK = GlmMojoModel.class.getDeclaredField("_link");
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

