/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm.testing;

import java.util.List;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.MisplacedAttributeException;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.visitors.AbstractVisitor;

public class FieldImportanceInspector
extends AbstractVisitor {
    public VisitorAction visit(MiningModel miningModel) {
        PMMLObject parent = this.getParent();
        if (parent instanceof PMML) {
            FieldImportanceInspector.ensureImportancesDefined((Model)miningModel);
        } else if (parent instanceof Segment) {
            FieldImportanceInspector.ensureImportancesNotDefined((Model)miningModel);
        }
        return super.visit(miningModel);
    }

    public VisitorAction visit(TreeModel treeModel) {
        FieldImportanceInspector.ensureImportancesNotDefined((Model)treeModel);
        return super.visit(treeModel);
    }

    private static void ensureImportancesDefined(Model model) {
        MiningSchema miningSchema = model.requireMiningSchema();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                Number importance = miningField.getImportance();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case TARGET: {
                        if (importance == null) break;
                        throw new MisplacedAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_IMPORTANCE, (Object)importance);
                    }
                    case ACTIVE: {
                        if (importance != null) break;
                        throw new MissingAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_IMPORTANCE);
                    }
                }
            }
        }
    }

    private static void ensureImportancesNotDefined(Model model) {
        MiningSchema miningSchema = model.requireMiningSchema();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                Number importance = miningField.getImportance();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case TARGET: 
                    case ACTIVE: {
                        if (importance == null) break;
                        throw new MisplacedAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_IMPORTANCE, (Object)importance);
                    }
                }
            }
        }
    }
}

