/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.lightgbm.Section;
import org.jpmml.lightgbm.Tree;

public abstract class ObjectiveFunction {
    private String name_;
    private boolean average_output_;
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_AVERAGE_OUTPUT = "average_output";

    public ObjectiveFunction(Section config) {
        this.name_ = config.get(CONFIG_NAME);
        this.average_output_ = config.containsKey(CONFIG_AVERAGE_OUTPUT);
    }

    public abstract Label encodeLabel(String var1, List<?> var2, PMMLEncoder var3);

    public abstract MiningModel encodeMiningModel(List<Tree> var1, Integer var2, Schema var3);

    protected MiningModel createMiningModel(List<Tree> trees, Integer numIteration, Schema schema) {
        ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        Schema segmentSchema = schema.toAnonymousSchema();
        PredicateManager predicateManager = new PredicateManager();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        if (numIteration != null) {
            if (numIteration > trees.size()) {
                throw new IllegalArgumentException("Tree limit " + numIteration + " is greater than the number of trees");
            }
            trees = trees.subList(0, numIteration);
        }
        for (Tree tree : trees) {
            TreeModel treeModel = tree.encodeTreeModel(predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)continuousLabel)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)(this.average_output_ ? Segmentation.MultipleModelMethod.AVERAGE : Segmentation.MultipleModelMethod.SUM), treeModels));
        return miningModel;
    }

    public String getName() {
        return this.name_;
    }

    public boolean getAverageOutput() {
        return this.average_output_;
    }
}

