/**
 * Base class for instrumentation versions.
 * Provides functionality to generate image URIs for different instrumentation types.
 */
export declare abstract class InstrumentationVersion {
    protected readonly imageRepo: string;
    protected readonly version: string;
    protected readonly memoryLimit: number;
    constructor(imageRepo: string, version: string, memoryLimit: number);
    /**
     * Get the image URI for the instrumentation version.
     * @returns The image URI.
     */
    imageURI(): string;
    /**
     * Get the memory limit in MiB for the instrumentation version.
     * @returns The memory limit
     */
    memoryLimitMiB(): number;
}
/**
 * Available versions for Java instrumentation.
 */
export declare class JavaInstrumentationVersion extends InstrumentationVersion {
    /**
     * The image repository for Java instrumentation.
     */
    static readonly IMAGE_REPO = "public.ecr.aws/aws-observability/adot-autoinstrumentation-java";
    /**
     * The default memory limit of the Java instrumentation.
     */
    static readonly DEFAULT_MEMORY_LIMIT_MIB = 64;
    /**
     * ADOT Java Instrumentation version 2.10.0
     */
    static readonly V2_10_0: JavaInstrumentationVersion;
    /**
     * ADOT Java Instrumentation version 1.33.0
     */
    static readonly V1_33_0: JavaInstrumentationVersion;
    /**
     * ADOT Java Instrumentation version 1.32.6
     */
    static readonly V1_32_6: JavaInstrumentationVersion;
}
/**
 * Available versions for .NET instrumentation.
 */
/**
 * Available versions for Python instrumentation.
 */
export declare class PythonInstrumentationVersion extends InstrumentationVersion {
    /**
     * The image repository for Python instrumentation.
     */
    static readonly IMAGE_REPO = "public.ecr.aws/aws-observability/adot-autoinstrumentation-python";
    /**
     * The default memory limit of the Python instrumentation.
     */
    static readonly DEFAULT_MEMORY_LIMIT_MIB = 32;
    /**
     * ADOT Python Instrumentation version 0.8.0
     */
    static readonly V0_8_0: PythonInstrumentationVersion;
    /**
     * ADOT Python Instrumentation version 0.8.0
     */
    static readonly V0_9_0: PythonInstrumentationVersion;
}
/**
 * Available versions for .NET instrumentation.
 */
export declare class DotnetInstrumentationVersion extends InstrumentationVersion {
    /**
     * The image repository for .NET instrumentation.
     */
    static readonly IMAGE_REPO = "public.ecr.aws/aws-observability/adot-autoinstrumentation-dotnet";
    /**
     * The default memory limit of the .NET instrumentation.
     */
    static readonly DEFAULT_MEMORY_LIMIT_MIB = 128;
    /**
     * ADOT .NET Instrumentation version 1.6.0
     */
    static readonly V1_6_0: DotnetInstrumentationVersion;
    /**
     * ADOT .NET Instrumentation version 1.6.0 for Windows 2022
     */
    static readonly V1_6_0_WINDOWS2022: DotnetInstrumentationVersion;
    /**
     * ADOT .NET Instrumentation version 1.6.0 for Windows 2019
     */
    static readonly V1_6_0_WINDOWS2019: DotnetInstrumentationVersion;
    /**
     * ADOT .NET Instrumentation version 1.7.0
     */
    static readonly V1_7_0: DotnetInstrumentationVersion;
    /**
     * ADOT .NET Instrumentation version 1.7.0 for Windows 2022
     */
    static readonly V1_7_0_WINDOWS2022: DotnetInstrumentationVersion;
    /**
     * ADOT .NET Instrumentation version 1.7.0 for Windows 2019
     */
    static readonly V1_7_0_WINDOWS2019: DotnetInstrumentationVersion;
}
/**
 * Available versions for Node.js instrumentation.
 */
export declare class NodeInstrumentationVersion extends InstrumentationVersion {
    /**
     * The image repository for Node.js instrumentation.
     */
    static readonly IMAGE_REPO = "public.ecr.aws/aws-observability/adot-autoinstrumentation-node";
    /**
     * The default memory limit of the Node.js instrumentation.
     */
    static readonly DEFAULT_MEMORY_LIMIT_MIB = 128;
    /**
     * ADOT Node.js Instrumentation version 0.5.0
     */
    static readonly V0_5_0: NodeInstrumentationVersion;
    /**
     * ADOT Node.js Instrumentation version 0.6.0
     */
    static readonly V0_6_0: NodeInstrumentationVersion;
}
