"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeInstrumentation = exports.DotnetInstrumentation = exports.PythonInstrumentation = exports.JavaInstrumentation = exports.TraceExporting = exports.MetricsExporting = exports.LogsExporting = exports.CommonExporting = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Common OpenTelemetry exporter configurations and AWS Application Signals settings.
 * Contains constants for OTLP protocol, resource attributes, and Application Signals enablement.
 */
class CommonExporting {
}
exports.CommonExporting = CommonExporting;
_a = JSII_RTTI_SYMBOL_1;
CommonExporting[_a] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.CommonExporting", version: "2.202.0-alpha.0" };
/** Protocol configuration for OpenTelemetry OTLP exporter */
CommonExporting.OTEL_EXPORTER_OTLP_PROTOCOL = 'OTEL_EXPORTER_OTLP_PROTOCOL';
/** HTTP/Protobuf protocol setting for OTLP exporter */
CommonExporting.OTEL_EXPORTER_OTLP_PROTOCOL_HTTP_PROTOBUF = 'http/protobuf';
/** Resource attribute configuration for service.name */
CommonExporting.OTEL_SERVICE_NAME = 'OTEL_SERVICE_NAME';
/** Resource attributes configuration for OpenTelemetry */
CommonExporting.OTEL_RESOURCE_ATTRIBUTES = 'OTEL_RESOURCE_ATTRIBUTES';
/** Flag to enable/disable AWS Application Signals */
CommonExporting.OTEL_AWS_APPLICATION_SIGNALS = 'OTEL_AWS_APPLICATION_SIGNALS_ENABLED';
/** Value to enable AWS Application Signals */
CommonExporting.OTEL_AWS_APPLICATION_SIGNALS_ENABLED = 'true';
/** Value to disable AWS Application Signals */
CommonExporting.OTEL_AWS_APPLICATION_SIGNALS_DISABLED = 'false';
/** Runtime configuration for AWS Application Signals */
CommonExporting.OTEL_AWS_APPLICATION_SIGNALS_RUNTIME = 'OTEL_AWS_APPLICATION_SIGNALS_RUNTIME_ENABLED';
/** Value to enable AWS Application Signals runtime */
CommonExporting.OTEL_AWS_APPLICATION_SIGNALS_RUNTIME_ENABLED = 'true';
/** Value to disable AWS Application Signals runtime */
CommonExporting.OTEL_AWS_APPLICATION_SIGNALS_RUNTIME_DISABLED = 'false';
/** Endpoint configuration for AWS Application Signals exporter */
CommonExporting.OTEL_AWS_APPLICATION_SIGNALS_EXPORTER_ENDPOINT = 'OTEL_AWS_APPLICATION_SIGNALS_EXPORTER_ENDPOINT';
/** Local CloudWatch Agent endpoint for metrics */
CommonExporting.OTEL_AWS_APPLICATION_SIGNALS_EXPORTER_ENDPOINT_LOCAL_CWA = 'http://localhost:4316/v1/metrics';
/**
 * OpenTelemetry logs exporter configurations.
 * Contains constants for configuring log export behavior.
 */
class LogsExporting {
}
exports.LogsExporting = LogsExporting;
_b = JSII_RTTI_SYMBOL_1;
LogsExporting[_b] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.LogsExporting", version: "2.202.0-alpha.0" };
/** Configuration for OpenTelemetry logs exporter */
LogsExporting.OTEL_LOGS_EXPORTER = 'OTEL_LOGS_EXPORTER';
/** Disable logs export */
LogsExporting.OTEL_LOGS_EXPORTER_NONE = 'none';
/** Enable OTLP logs export */
LogsExporting.OTEL_LOGS_EXPORTER_OTLP = 'otlp';
/**
 * OpenTelemetry metrics exporter configurations.
 * Contains constants for configuring metrics export behavior.
 */
class MetricsExporting {
}
exports.MetricsExporting = MetricsExporting;
_c = JSII_RTTI_SYMBOL_1;
MetricsExporting[_c] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.MetricsExporting", version: "2.202.0-alpha.0" };
/** Configuration for OpenTelemetry metrics exporter */
MetricsExporting.OTEL_METRICS_EXPORTER = 'OTEL_METRICS_EXPORTER';
/** Disable metrics export */
MetricsExporting.OTEL_METRICS_EXPORTER_NONE = 'none';
/** Enable OTLP metrics export */
MetricsExporting.OTEL_METRICS_EXPORTER_OTLP = 'otlp';
/**
 * OpenTelemetry trace exporter and sampling configurations.
 * Contains constants for trace endpoints, sampling strategies, and propagation formats.
 */
class TraceExporting {
}
exports.TraceExporting = TraceExporting;
_d = JSII_RTTI_SYMBOL_1;
TraceExporting[_d] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.TraceExporting", version: "2.202.0-alpha.0" };
/** Endpoint configuration for OTLP traces */
TraceExporting.OTEL_EXPORTER_OTLP_TRACES_ENDPOINT = 'OTEL_EXPORTER_OTLP_TRACES_ENDPOINT';
/** Local CloudWatch Agent endpoint for traces */
TraceExporting.OTEL_EXPORTER_OTLP_TRACES_ENDPOINT_LOCAL_CWA = 'http://localhost:4316/v1/traces';
/** Sampling configuration for traces */
TraceExporting.OTEL_TRACES_SAMPLER = 'OTEL_TRACES_SAMPLER';
/** X-Ray sampling strategy */
TraceExporting.OTEL_TRACES_SAMPLER_XRAY = 'xray';
/** Trace ID ratio based sampling */
TraceExporting.OTEL_TRACES_SAMPLER_TRACEID_RATIO = 'traceidratio';
/** Sample all traces */
TraceExporting.OTEL_TRACES_SAMPLER_ALWAYS_ON = 'always_on';
/** Sample no traces */
TraceExporting.OTEL_TRACES_SAMPLER_ALWAYS_OFF = 'always_off';
/** Parent-based trace ID ratio sampling */
TraceExporting.OTEL_TRACES_SAMPLER_PARENT_BASED_TRACEID_RATIO = 'parentbased_traceidratio';
/** Parent-based always on sampling */
TraceExporting.OTEL_TRACES_SAMPLER_PARENT_BASED_ALWAYS_ON = 'parentbased_always_on';
/** Parent-based always off sampling */
TraceExporting.OTEL_TRACES_SAMPLER_PARENT_BASED_ALWAYS_OFF = 'parentbased_always_off';
/** Arguments for trace sampler configuration */
TraceExporting.OTEL_TRACES_SAMPLER_ARG = 'OTEL_TRACES_SAMPLER_ARG';
/** Local CloudWatch Agent endpoint for sampler */
TraceExporting.OTEL_TRACES_SAMPLER_ARG_LOCAL_CWA = 'endpoint=http://localhost:2000';
/** Configuration for trace context propagation */
TraceExporting.OTEL_PROPAGATORS = 'OTEL_PROPAGATORS';
/** Supported propagation formats for Application Signals */
TraceExporting.OTEL_PROPAGATORS_APPLICATION_SIGNALS = 'tracecontext,baggage,b3,xray';
/**
 * Java-specific OpenTelemetry instrumentation configurations.
 * Contains constants for Java agent setup and tool options.
 */
class JavaInstrumentation {
}
exports.JavaInstrumentation = JavaInstrumentation;
_e = JSII_RTTI_SYMBOL_1;
JavaInstrumentation[_e] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.JavaInstrumentation", version: "2.202.0-alpha.0" };
/** Java tool options environment variable */
JavaInstrumentation.JAVA_TOOL_OPTIONS = 'JAVA_TOOL_OPTIONS';
/**
 * Python-specific OpenTelemetry instrumentation configurations.
 * Contains constants for Python distribution, configurator, and path settings.
 */
class PythonInstrumentation {
}
exports.PythonInstrumentation = PythonInstrumentation;
_f = JSII_RTTI_SYMBOL_1;
PythonInstrumentation[_f] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.PythonInstrumentation", version: "2.202.0-alpha.0" };
/** Python OpenTelemetry distribution configuration */
PythonInstrumentation.OTEL_PYTHON_DISTRO = 'OTEL_PYTHON_DISTRO';
/** AWS distribution for Python OpenTelemetry */
PythonInstrumentation.OTEL_PYTHON_DISTRO_AWS_DISTRO = 'aws_distro';
/** Python OpenTelemetry configurator setting */
PythonInstrumentation.OTEL_PYTHON_CONFIGURATOR = 'OTEL_PYTHON_CONFIGURATOR';
/** AWS configurator for Python OpenTelemetry */
PythonInstrumentation.OTEL_PYTHON_CONFIGURATOR_AWS_CONFIGURATOR = 'aws_configurator';
/** Python path environment variable */
PythonInstrumentation.PYTHONPATH = 'PYTHONPATH';
/**
 * .NET-specific OpenTelemetry instrumentation configurations.
 * Contains constants for .NET runtime settings, profiler configurations, and paths
 * for both Linux and Windows environments.
 */
class DotnetInstrumentation {
}
exports.DotnetInstrumentation = DotnetInstrumentation;
_g = JSII_RTTI_SYMBOL_1;
DotnetInstrumentation[_g] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.DotnetInstrumentation", version: "2.202.0-alpha.0" };
/** .NET OpenTelemetry distribution configuration */
DotnetInstrumentation.OTEL_DOTNET_DISTRO = 'OTEL_DOTNET_DISTRO';
/** AWS distribution for .NET OpenTelemetry */
DotnetInstrumentation.OTEL_DOTNET_DISTRO_AWS_DISTRO = 'aws_distro';
/** .NET OpenTelemetry configurator setting */
DotnetInstrumentation.OTEL_DOTNET_CONFIGURATOR = 'OTEL_DOTNET_CONFIGURATOR';
/** AWS configurator for .NET OpenTelemetry */
DotnetInstrumentation.OTEL_DOTNET_CONFIGURATOR_AWS_CONFIGURATOR = 'aws_configurator';
/** .NET auto-instrumentation plugins configuration */
DotnetInstrumentation.OTEL_DOTNET_AUTO_PLUGINS = 'OTEL_DOTNET_AUTO_PLUGINS';
/** ADOT auto-instrumentation plugin for .NET */
DotnetInstrumentation.OTEL_DOTNET_AUTO_PLUGINS_ADOT = 'AWS.Distro.OpenTelemetry.AutoInstrumentation.Plugin, AWS.Distro.OpenTelemetry.AutoInstrumentation';
/** CoreCLR profiling enable flag */
DotnetInstrumentation.CORECLR_ENABLE_PROFILING = 'CORECLR_ENABLE_PROFILING';
/** Enable CoreCLR profiling */
DotnetInstrumentation.CORECLR_ENABLE_PROFILING_ENABLED = '1';
/** Disable CoreCLR profiling */
DotnetInstrumentation.CORECLR_ENABLE_PROFILING_DISABLED = '0';
/** CoreCLR profiler GUID */
DotnetInstrumentation.CORECLR_PROFILER = 'CORECLR_PROFILER';
/** OpenTelemetry CoreCLR profiler ID */
DotnetInstrumentation.CORECLR_PROFILER_OTEL = '{918728DD-259F-4A6A-AC2B-B85E1B658318}';
/** Path to CoreCLR profiler */
DotnetInstrumentation.CORECLR_PROFILER_PATH = 'CORECLR_PROFILER_PATH';
/** .NET startup hooks configuration */
DotnetInstrumentation.DOTNET_STARTUP_HOOKS = 'DOTNET_STARTUP_HOOKS';
/** Additional .NET dependencies configuration */
DotnetInstrumentation.DOTNET_ADDITIONAL_DEPS = 'DOTNET_ADDITIONAL_DEPS';
/** .NET auto-instrumentation home directory */
DotnetInstrumentation.OTEL_DOTNET_AUTO_HOME = 'OTEL_DOTNET_AUTO_HOME';
/** .NET shared store configuration */
DotnetInstrumentation.DOTNET_SHARED_STORE = 'DOTNET_SHARED_STORE';
/**
 * Node-specific OpenTelemetry instrumentation configurations.
 * Contains constants for Node.js runtime settings and options.
 */
class NodeInstrumentation {
}
exports.NodeInstrumentation = NodeInstrumentation;
_h = JSII_RTTI_SYMBOL_1;
NodeInstrumentation[_h] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.NodeInstrumentation", version: "2.202.0-alpha.0" };
/** Node.js options environment variable */
NodeInstrumentation.NODE_OPTIONS = 'NODE_OPTIONS';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29uc3RhbnRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7OztHQUdHO0FBQ0gsTUFBYSxlQUFlOztBQUE1QiwwQ0EyQkM7OztBQTFCQyw2REFBNkQ7QUFDdEMsMkNBQTJCLEdBQUcsNkJBQTZCLENBQUM7QUFDbkYsdURBQXVEO0FBQ2hDLHlEQUF5QyxHQUFHLGVBQWUsQ0FBQztBQUNuRix3REFBd0Q7QUFDakMsaUNBQWlCLEdBQUcsbUJBQW1CLENBQUM7QUFDL0QsMERBQTBEO0FBQ25DLHdDQUF3QixHQUFHLDBCQUEwQixDQUFDO0FBRTdFLHFEQUFxRDtBQUM5Qiw0Q0FBNEIsR0FBRyxzQ0FBc0MsQ0FBQztBQUM3Riw4Q0FBOEM7QUFDdkIsb0RBQW9DLEdBQUcsTUFBTSxDQUFDO0FBQ3JFLCtDQUErQztBQUN4QixxREFBcUMsR0FBRyxPQUFPLENBQUM7QUFDdkUsd0RBQXdEO0FBQ2pDLG9EQUFvQyxHQUFHLDhDQUE4QyxDQUFDO0FBQzdHLHNEQUFzRDtBQUMvQiw0REFBNEMsR0FBRyxNQUFNLENBQUM7QUFDN0UsdURBQXVEO0FBQ2hDLDZEQUE2QyxHQUFHLE9BQU8sQ0FBQztBQUUvRSxrRUFBa0U7QUFDM0MsOERBQThDLEdBQUcsZ0RBQWdELENBQUM7QUFDekgsa0RBQWtEO0FBQzNCLHdFQUF3RCxHQUFHLGtDQUFrQyxDQUFDO0FBR3ZIOzs7R0FHRztBQUNILE1BQWEsYUFBYTs7QUFBMUIsc0NBT0M7OztBQU5DLG9EQUFvRDtBQUM3QixnQ0FBa0IsR0FBRyxvQkFBb0IsQ0FBQztBQUNqRSwwQkFBMEI7QUFDSCxxQ0FBdUIsR0FBRyxNQUFNLENBQUM7QUFDeEQsOEJBQThCO0FBQ1AscUNBQXVCLEdBQUcsTUFBTSxDQUFDO0FBRzFEOzs7R0FHRztBQUNILE1BQWEsZ0JBQWdCOztBQUE3Qiw0Q0FPQzs7O0FBTkMsdURBQXVEO0FBQ2hDLHNDQUFxQixHQUFHLHVCQUF1QixDQUFDO0FBQ3ZFLDZCQUE2QjtBQUNOLDJDQUEwQixHQUFHLE1BQU0sQ0FBQztBQUMzRCxpQ0FBaUM7QUFDViwyQ0FBMEIsR0FBRyxNQUFNLENBQUM7QUFHN0Q7OztHQUdHO0FBQ0gsTUFBYSxjQUFjOztBQUEzQix3Q0FnQ0M7OztBQS9CQyw2Q0FBNkM7QUFDdEIsaURBQWtDLEdBQUcsb0NBQW9DLENBQUM7QUFDakcsaURBQWlEO0FBQzFCLDJEQUE0QyxHQUFHLGlDQUFpQyxDQUFDO0FBRXhHLHdDQUF3QztBQUNqQixrQ0FBbUIsR0FBRyxxQkFBcUIsQ0FBQztBQUNuRSw4QkFBOEI7QUFDUCx1Q0FBd0IsR0FBRyxNQUFNLENBQUM7QUFDekQsb0NBQW9DO0FBQ2IsZ0RBQWlDLEdBQUcsY0FBYyxDQUFDO0FBQzFFLHdCQUF3QjtBQUNELDRDQUE2QixHQUFHLFdBQVcsQ0FBQztBQUNuRSx1QkFBdUI7QUFDQSw2Q0FBOEIsR0FBRyxZQUFZLENBQUM7QUFDckUsMkNBQTJDO0FBQ3BCLDZEQUE4QyxHQUFHLDBCQUEwQixDQUFDO0FBQ25HLHNDQUFzQztBQUNmLHlEQUEwQyxHQUFHLHVCQUF1QixDQUFDO0FBQzVGLHVDQUF1QztBQUNoQiwwREFBMkMsR0FBRyx3QkFBd0IsQ0FBQztBQUU5RixnREFBZ0Q7QUFDekIsc0NBQXVCLEdBQUcseUJBQXlCLENBQUM7QUFDM0Usa0RBQWtEO0FBQzNCLGdEQUFpQyxHQUFHLGdDQUFnQyxDQUFDO0FBRTVGLGtEQUFrRDtBQUMzQiwrQkFBZ0IsR0FBRyxrQkFBa0IsQ0FBQztBQUM3RCw0REFBNEQ7QUFDckMsbURBQW9DLEdBQUcsOEJBQThCLENBQUM7QUFHL0Y7OztHQUdHO0FBQ0gsTUFBYSxtQkFBbUI7O0FBQWhDLGtEQUdDOzs7QUFGQyw2Q0FBNkM7QUFDdEIscUNBQWlCLEdBQUcsbUJBQW1CLENBQUM7QUFHakU7OztHQUdHO0FBQ0gsTUFBYSxxQkFBcUI7O0FBQWxDLHNEQVlDOzs7QUFYQyxzREFBc0Q7QUFDL0Isd0NBQWtCLEdBQUcsb0JBQW9CLENBQUM7QUFDakUsZ0RBQWdEO0FBQ3pCLG1EQUE2QixHQUFHLFlBQVksQ0FBQztBQUVwRSxnREFBZ0Q7QUFDekIsOENBQXdCLEdBQUcsMEJBQTBCLENBQUM7QUFDN0UsZ0RBQWdEO0FBQ3pCLCtEQUF5QyxHQUFHLGtCQUFrQixDQUFDO0FBQ3RGLHVDQUF1QztBQUNoQixnQ0FBVSxHQUFHLFlBQVksQ0FBQztBQUduRDs7OztHQUlHO0FBQ0gsTUFBYSxxQkFBcUI7O0FBQWxDLHNEQW1DQzs7O0FBbENDLG9EQUFvRDtBQUM3Qix3Q0FBa0IsR0FBRyxvQkFBb0IsQ0FBQztBQUNqRSw4Q0FBOEM7QUFDdkIsbURBQTZCLEdBQUcsWUFBWSxDQUFDO0FBQ3BFLDhDQUE4QztBQUN2Qiw4Q0FBd0IsR0FBRywwQkFBMEIsQ0FBQztBQUM3RSw4Q0FBOEM7QUFDdkIsK0RBQXlDLEdBQUcsa0JBQWtCLENBQUM7QUFDdEYsc0RBQXNEO0FBQy9CLDhDQUF3QixHQUFHLDBCQUEwQixDQUFDO0FBQzdFLGdEQUFnRDtBQUN6QixtREFBNkIsR0FBRyxtR0FBbUcsQ0FBQztBQUMzSixvQ0FBb0M7QUFDYiw4Q0FBd0IsR0FBRywwQkFBMEIsQ0FBQztBQUM3RSwrQkFBK0I7QUFDUixzREFBZ0MsR0FBRyxHQUFHLENBQUM7QUFDOUQsZ0NBQWdDO0FBQ1QsdURBQWlDLEdBQUcsR0FBRyxDQUFDO0FBQy9ELDRCQUE0QjtBQUNMLHNDQUFnQixHQUFHLGtCQUFrQixDQUFDO0FBQzdELHdDQUF3QztBQUNqQiwyQ0FBcUIsR0FBRyx3Q0FBd0MsQ0FBQztBQUN4RiwrQkFBK0I7QUFDUiwyQ0FBcUIsR0FBRyx1QkFBdUIsQ0FBQztBQUN2RSx1Q0FBdUM7QUFDaEIsMENBQW9CLEdBQUcsc0JBQXNCLENBQUM7QUFDckUsaURBQWlEO0FBQzFCLDRDQUFzQixHQUFHLHdCQUF3QixDQUFDO0FBRXpFLCtDQUErQztBQUN4QiwyQ0FBcUIsR0FBRyx1QkFBdUIsQ0FBQztBQUV2RSxzQ0FBc0M7QUFDZix5Q0FBbUIsR0FBRyxxQkFBcUIsQ0FBQztBQUdyRTs7O0dBR0c7QUFDSCxNQUFhLG1CQUFtQjs7QUFBaEMsa0RBR0M7OztBQUZDLDJDQUEyQztBQUNwQixnQ0FBWSxHQUFHLGNBQWMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29tbW9uIE9wZW5UZWxlbWV0cnkgZXhwb3J0ZXIgY29uZmlndXJhdGlvbnMgYW5kIEFXUyBBcHBsaWNhdGlvbiBTaWduYWxzIHNldHRpbmdzLlxuICogQ29udGFpbnMgY29uc3RhbnRzIGZvciBPVExQIHByb3RvY29sLCByZXNvdXJjZSBhdHRyaWJ1dGVzLCBhbmQgQXBwbGljYXRpb24gU2lnbmFscyBlbmFibGVtZW50LlxuICovXG5leHBvcnQgY2xhc3MgQ29tbW9uRXhwb3J0aW5nIHtcbiAgLyoqIFByb3RvY29sIGNvbmZpZ3VyYXRpb24gZm9yIE9wZW5UZWxlbWV0cnkgT1RMUCBleHBvcnRlciAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfRVhQT1JURVJfT1RMUF9QUk9UT0NPTCA9ICdPVEVMX0VYUE9SVEVSX09UTFBfUFJPVE9DT0wnO1xuICAvKiogSFRUUC9Qcm90b2J1ZiBwcm90b2NvbCBzZXR0aW5nIGZvciBPVExQIGV4cG9ydGVyICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9FWFBPUlRFUl9PVExQX1BST1RPQ09MX0hUVFBfUFJPVE9CVUYgPSAnaHR0cC9wcm90b2J1Zic7XG4gIC8qKiBSZXNvdXJjZSBhdHRyaWJ1dGUgY29uZmlndXJhdGlvbiBmb3Igc2VydmljZS5uYW1lICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9TRVJWSUNFX05BTUUgPSAnT1RFTF9TRVJWSUNFX05BTUUnO1xuICAvKiogUmVzb3VyY2UgYXR0cmlidXRlcyBjb25maWd1cmF0aW9uIGZvciBPcGVuVGVsZW1ldHJ5ICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9SRVNPVVJDRV9BVFRSSUJVVEVTID0gJ09URUxfUkVTT1VSQ0VfQVRUUklCVVRFUyc7XG5cbiAgLyoqIEZsYWcgdG8gZW5hYmxlL2Rpc2FibGUgQVdTIEFwcGxpY2F0aW9uIFNpZ25hbHMgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX0FXU19BUFBMSUNBVElPTl9TSUdOQUxTID0gJ09URUxfQVdTX0FQUExJQ0FUSU9OX1NJR05BTFNfRU5BQkxFRCc7XG4gIC8qKiBWYWx1ZSB0byBlbmFibGUgQVdTIEFwcGxpY2F0aW9uIFNpZ25hbHMgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX0FXU19BUFBMSUNBVElPTl9TSUdOQUxTX0VOQUJMRUQgPSAndHJ1ZSc7XG4gIC8qKiBWYWx1ZSB0byBkaXNhYmxlIEFXUyBBcHBsaWNhdGlvbiBTaWduYWxzICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9BV1NfQVBQTElDQVRJT05fU0lHTkFMU19ESVNBQkxFRCA9ICdmYWxzZSc7XG4gIC8qKiBSdW50aW1lIGNvbmZpZ3VyYXRpb24gZm9yIEFXUyBBcHBsaWNhdGlvbiBTaWduYWxzICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9BV1NfQVBQTElDQVRJT05fU0lHTkFMU19SVU5USU1FID0gJ09URUxfQVdTX0FQUExJQ0FUSU9OX1NJR05BTFNfUlVOVElNRV9FTkFCTEVEJztcbiAgLyoqIFZhbHVlIHRvIGVuYWJsZSBBV1MgQXBwbGljYXRpb24gU2lnbmFscyBydW50aW1lICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9BV1NfQVBQTElDQVRJT05fU0lHTkFMU19SVU5USU1FX0VOQUJMRUQgPSAndHJ1ZSc7XG4gIC8qKiBWYWx1ZSB0byBkaXNhYmxlIEFXUyBBcHBsaWNhdGlvbiBTaWduYWxzIHJ1bnRpbWUgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX0FXU19BUFBMSUNBVElPTl9TSUdOQUxTX1JVTlRJTUVfRElTQUJMRUQgPSAnZmFsc2UnO1xuXG4gIC8qKiBFbmRwb2ludCBjb25maWd1cmF0aW9uIGZvciBBV1MgQXBwbGljYXRpb24gU2lnbmFscyBleHBvcnRlciAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfQVdTX0FQUExJQ0FUSU9OX1NJR05BTFNfRVhQT1JURVJfRU5EUE9JTlQgPSAnT1RFTF9BV1NfQVBQTElDQVRJT05fU0lHTkFMU19FWFBPUlRFUl9FTkRQT0lOVCc7XG4gIC8qKiBMb2NhbCBDbG91ZFdhdGNoIEFnZW50IGVuZHBvaW50IGZvciBtZXRyaWNzICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9BV1NfQVBQTElDQVRJT05fU0lHTkFMU19FWFBPUlRFUl9FTkRQT0lOVF9MT0NBTF9DV0EgPSAnaHR0cDovL2xvY2FsaG9zdDo0MzE2L3YxL21ldHJpY3MnO1xufVxuXG4vKipcbiAqIE9wZW5UZWxlbWV0cnkgbG9ncyBleHBvcnRlciBjb25maWd1cmF0aW9ucy5cbiAqIENvbnRhaW5zIGNvbnN0YW50cyBmb3IgY29uZmlndXJpbmcgbG9nIGV4cG9ydCBiZWhhdmlvci5cbiAqL1xuZXhwb3J0IGNsYXNzIExvZ3NFeHBvcnRpbmcge1xuICAvKiogQ29uZmlndXJhdGlvbiBmb3IgT3BlblRlbGVtZXRyeSBsb2dzIGV4cG9ydGVyICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9MT0dTX0VYUE9SVEVSID0gJ09URUxfTE9HU19FWFBPUlRFUic7XG4gIC8qKiBEaXNhYmxlIGxvZ3MgZXhwb3J0ICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9MT0dTX0VYUE9SVEVSX05PTkUgPSAnbm9uZSc7XG4gIC8qKiBFbmFibGUgT1RMUCBsb2dzIGV4cG9ydCAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfTE9HU19FWFBPUlRFUl9PVExQID0gJ290bHAnO1xufVxuXG4vKipcbiAqIE9wZW5UZWxlbWV0cnkgbWV0cmljcyBleHBvcnRlciBjb25maWd1cmF0aW9ucy5cbiAqIENvbnRhaW5zIGNvbnN0YW50cyBmb3IgY29uZmlndXJpbmcgbWV0cmljcyBleHBvcnQgYmVoYXZpb3IuXG4gKi9cbmV4cG9ydCBjbGFzcyBNZXRyaWNzRXhwb3J0aW5nIHtcbiAgLyoqIENvbmZpZ3VyYXRpb24gZm9yIE9wZW5UZWxlbWV0cnkgbWV0cmljcyBleHBvcnRlciAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfTUVUUklDU19FWFBPUlRFUiA9ICdPVEVMX01FVFJJQ1NfRVhQT1JURVInO1xuICAvKiogRGlzYWJsZSBtZXRyaWNzIGV4cG9ydCAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfTUVUUklDU19FWFBPUlRFUl9OT05FID0gJ25vbmUnO1xuICAvKiogRW5hYmxlIE9UTFAgbWV0cmljcyBleHBvcnQgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX01FVFJJQ1NfRVhQT1JURVJfT1RMUCA9ICdvdGxwJztcbn1cblxuLyoqXG4gKiBPcGVuVGVsZW1ldHJ5IHRyYWNlIGV4cG9ydGVyIGFuZCBzYW1wbGluZyBjb25maWd1cmF0aW9ucy5cbiAqIENvbnRhaW5zIGNvbnN0YW50cyBmb3IgdHJhY2UgZW5kcG9pbnRzLCBzYW1wbGluZyBzdHJhdGVnaWVzLCBhbmQgcHJvcGFnYXRpb24gZm9ybWF0cy5cbiAqL1xuZXhwb3J0IGNsYXNzIFRyYWNlRXhwb3J0aW5nIHtcbiAgLyoqIEVuZHBvaW50IGNvbmZpZ3VyYXRpb24gZm9yIE9UTFAgdHJhY2VzICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9FWFBPUlRFUl9PVExQX1RSQUNFU19FTkRQT0lOVCA9ICdPVEVMX0VYUE9SVEVSX09UTFBfVFJBQ0VTX0VORFBPSU5UJztcbiAgLyoqIExvY2FsIENsb3VkV2F0Y2ggQWdlbnQgZW5kcG9pbnQgZm9yIHRyYWNlcyAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfRVhQT1JURVJfT1RMUF9UUkFDRVNfRU5EUE9JTlRfTE9DQUxfQ1dBID0gJ2h0dHA6Ly9sb2NhbGhvc3Q6NDMxNi92MS90cmFjZXMnO1xuXG4gIC8qKiBTYW1wbGluZyBjb25maWd1cmF0aW9uIGZvciB0cmFjZXMgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX1RSQUNFU19TQU1QTEVSID0gJ09URUxfVFJBQ0VTX1NBTVBMRVInO1xuICAvKiogWC1SYXkgc2FtcGxpbmcgc3RyYXRlZ3kgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX1RSQUNFU19TQU1QTEVSX1hSQVkgPSAneHJheSc7XG4gIC8qKiBUcmFjZSBJRCByYXRpbyBiYXNlZCBzYW1wbGluZyAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfVFJBQ0VTX1NBTVBMRVJfVFJBQ0VJRF9SQVRJTyA9ICd0cmFjZWlkcmF0aW8nO1xuICAvKiogU2FtcGxlIGFsbCB0cmFjZXMgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX1RSQUNFU19TQU1QTEVSX0FMV0FZU19PTiA9ICdhbHdheXNfb24nO1xuICAvKiogU2FtcGxlIG5vIHRyYWNlcyAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfVFJBQ0VTX1NBTVBMRVJfQUxXQVlTX09GRiA9ICdhbHdheXNfb2ZmJztcbiAgLyoqIFBhcmVudC1iYXNlZCB0cmFjZSBJRCByYXRpbyBzYW1wbGluZyAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfVFJBQ0VTX1NBTVBMRVJfUEFSRU5UX0JBU0VEX1RSQUNFSURfUkFUSU8gPSAncGFyZW50YmFzZWRfdHJhY2VpZHJhdGlvJztcbiAgLyoqIFBhcmVudC1iYXNlZCBhbHdheXMgb24gc2FtcGxpbmcgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX1RSQUNFU19TQU1QTEVSX1BBUkVOVF9CQVNFRF9BTFdBWVNfT04gPSAncGFyZW50YmFzZWRfYWx3YXlzX29uJztcbiAgLyoqIFBhcmVudC1iYXNlZCBhbHdheXMgb2ZmIHNhbXBsaW5nICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9UUkFDRVNfU0FNUExFUl9QQVJFTlRfQkFTRURfQUxXQVlTX09GRiA9ICdwYXJlbnRiYXNlZF9hbHdheXNfb2ZmJztcblxuICAvKiogQXJndW1lbnRzIGZvciB0cmFjZSBzYW1wbGVyIGNvbmZpZ3VyYXRpb24gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX1RSQUNFU19TQU1QTEVSX0FSRyA9ICdPVEVMX1RSQUNFU19TQU1QTEVSX0FSRyc7XG4gIC8qKiBMb2NhbCBDbG91ZFdhdGNoIEFnZW50IGVuZHBvaW50IGZvciBzYW1wbGVyICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9UUkFDRVNfU0FNUExFUl9BUkdfTE9DQUxfQ1dBID0gJ2VuZHBvaW50PWh0dHA6Ly9sb2NhbGhvc3Q6MjAwMCc7XG5cbiAgLyoqIENvbmZpZ3VyYXRpb24gZm9yIHRyYWNlIGNvbnRleHQgcHJvcGFnYXRpb24gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX1BST1BBR0FUT1JTID0gJ09URUxfUFJPUEFHQVRPUlMnO1xuICAvKiogU3VwcG9ydGVkIHByb3BhZ2F0aW9uIGZvcm1hdHMgZm9yIEFwcGxpY2F0aW9uIFNpZ25hbHMgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX1BST1BBR0FUT1JTX0FQUExJQ0FUSU9OX1NJR05BTFMgPSAndHJhY2Vjb250ZXh0LGJhZ2dhZ2UsYjMseHJheSc7XG59XG5cbi8qKlxuICogSmF2YS1zcGVjaWZpYyBPcGVuVGVsZW1ldHJ5IGluc3RydW1lbnRhdGlvbiBjb25maWd1cmF0aW9ucy5cbiAqIENvbnRhaW5zIGNvbnN0YW50cyBmb3IgSmF2YSBhZ2VudCBzZXR1cCBhbmQgdG9vbCBvcHRpb25zLlxuICovXG5leHBvcnQgY2xhc3MgSmF2YUluc3RydW1lbnRhdGlvbiB7XG4gIC8qKiBKYXZhIHRvb2wgb3B0aW9ucyBlbnZpcm9ubWVudCB2YXJpYWJsZSAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEpBVkFfVE9PTF9PUFRJT05TID0gJ0pBVkFfVE9PTF9PUFRJT05TJztcbn1cblxuLyoqXG4gKiBQeXRob24tc3BlY2lmaWMgT3BlblRlbGVtZXRyeSBpbnN0cnVtZW50YXRpb24gY29uZmlndXJhdGlvbnMuXG4gKiBDb250YWlucyBjb25zdGFudHMgZm9yIFB5dGhvbiBkaXN0cmlidXRpb24sIGNvbmZpZ3VyYXRvciwgYW5kIHBhdGggc2V0dGluZ3MuXG4gKi9cbmV4cG9ydCBjbGFzcyBQeXRob25JbnN0cnVtZW50YXRpb24ge1xuICAvKiogUHl0aG9uIE9wZW5UZWxlbWV0cnkgZGlzdHJpYnV0aW9uIGNvbmZpZ3VyYXRpb24gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX1BZVEhPTl9ESVNUUk8gPSAnT1RFTF9QWVRIT05fRElTVFJPJztcbiAgLyoqIEFXUyBkaXN0cmlidXRpb24gZm9yIFB5dGhvbiBPcGVuVGVsZW1ldHJ5ICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9QWVRIT05fRElTVFJPX0FXU19ESVNUUk8gPSAnYXdzX2Rpc3Rybyc7XG5cbiAgLyoqIFB5dGhvbiBPcGVuVGVsZW1ldHJ5IGNvbmZpZ3VyYXRvciBzZXR0aW5nICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9QWVRIT05fQ09ORklHVVJBVE9SID0gJ09URUxfUFlUSE9OX0NPTkZJR1VSQVRPUic7XG4gIC8qKiBBV1MgY29uZmlndXJhdG9yIGZvciBQeXRob24gT3BlblRlbGVtZXRyeSAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfUFlUSE9OX0NPTkZJR1VSQVRPUl9BV1NfQ09ORklHVVJBVE9SID0gJ2F3c19jb25maWd1cmF0b3InO1xuICAvKiogUHl0aG9uIHBhdGggZW52aXJvbm1lbnQgdmFyaWFibGUgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQWVRIT05QQVRIID0gJ1BZVEhPTlBBVEgnO1xufVxuXG4vKipcbiAqIC5ORVQtc3BlY2lmaWMgT3BlblRlbGVtZXRyeSBpbnN0cnVtZW50YXRpb24gY29uZmlndXJhdGlvbnMuXG4gKiBDb250YWlucyBjb25zdGFudHMgZm9yIC5ORVQgcnVudGltZSBzZXR0aW5ncywgcHJvZmlsZXIgY29uZmlndXJhdGlvbnMsIGFuZCBwYXRoc1xuICogZm9yIGJvdGggTGludXggYW5kIFdpbmRvd3MgZW52aXJvbm1lbnRzLlxuICovXG5leHBvcnQgY2xhc3MgRG90bmV0SW5zdHJ1bWVudGF0aW9uIHtcbiAgLyoqIC5ORVQgT3BlblRlbGVtZXRyeSBkaXN0cmlidXRpb24gY29uZmlndXJhdGlvbiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfRE9UTkVUX0RJU1RSTyA9ICdPVEVMX0RPVE5FVF9ESVNUUk8nO1xuICAvKiogQVdTIGRpc3RyaWJ1dGlvbiBmb3IgLk5FVCBPcGVuVGVsZW1ldHJ5ICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9ET1RORVRfRElTVFJPX0FXU19ESVNUUk8gPSAnYXdzX2Rpc3Rybyc7XG4gIC8qKiAuTkVUIE9wZW5UZWxlbWV0cnkgY29uZmlndXJhdG9yIHNldHRpbmcgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX0RPVE5FVF9DT05GSUdVUkFUT1IgPSAnT1RFTF9ET1RORVRfQ09ORklHVVJBVE9SJztcbiAgLyoqIEFXUyBjb25maWd1cmF0b3IgZm9yIC5ORVQgT3BlblRlbGVtZXRyeSAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfRE9UTkVUX0NPTkZJR1VSQVRPUl9BV1NfQ09ORklHVVJBVE9SID0gJ2F3c19jb25maWd1cmF0b3InO1xuICAvKiogLk5FVCBhdXRvLWluc3RydW1lbnRhdGlvbiBwbHVnaW5zIGNvbmZpZ3VyYXRpb24gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPVEVMX0RPVE5FVF9BVVRPX1BMVUdJTlMgPSAnT1RFTF9ET1RORVRfQVVUT19QTFVHSU5TJztcbiAgLyoqIEFET1QgYXV0by1pbnN0cnVtZW50YXRpb24gcGx1Z2luIGZvciAuTkVUICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1RFTF9ET1RORVRfQVVUT19QTFVHSU5TX0FET1QgPSAnQVdTLkRpc3Ryby5PcGVuVGVsZW1ldHJ5LkF1dG9JbnN0cnVtZW50YXRpb24uUGx1Z2luLCBBV1MuRGlzdHJvLk9wZW5UZWxlbWV0cnkuQXV0b0luc3RydW1lbnRhdGlvbic7XG4gIC8qKiBDb3JlQ0xSIHByb2ZpbGluZyBlbmFibGUgZmxhZyAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPUkVDTFJfRU5BQkxFX1BST0ZJTElORyA9ICdDT1JFQ0xSX0VOQUJMRV9QUk9GSUxJTkcnO1xuICAvKiogRW5hYmxlIENvcmVDTFIgcHJvZmlsaW5nICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09SRUNMUl9FTkFCTEVfUFJPRklMSU5HX0VOQUJMRUQgPSAnMSc7XG4gIC8qKiBEaXNhYmxlIENvcmVDTFIgcHJvZmlsaW5nICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09SRUNMUl9FTkFCTEVfUFJPRklMSU5HX0RJU0FCTEVEID0gJzAnO1xuICAvKiogQ29yZUNMUiBwcm9maWxlciBHVUlEICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09SRUNMUl9QUk9GSUxFUiA9ICdDT1JFQ0xSX1BST0ZJTEVSJztcbiAgLyoqIE9wZW5UZWxlbWV0cnkgQ29yZUNMUiBwcm9maWxlciBJRCAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPUkVDTFJfUFJPRklMRVJfT1RFTCA9ICd7OTE4NzI4REQtMjU5Ri00QTZBLUFDMkItQjg1RTFCNjU4MzE4fSc7XG4gIC8qKiBQYXRoIHRvIENvcmVDTFIgcHJvZmlsZXIgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT1JFQ0xSX1BST0ZJTEVSX1BBVEggPSAnQ09SRUNMUl9QUk9GSUxFUl9QQVRIJztcbiAgLyoqIC5ORVQgc3RhcnR1cCBob29rcyBjb25maWd1cmF0aW9uICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRE9UTkVUX1NUQVJUVVBfSE9PS1MgPSAnRE9UTkVUX1NUQVJUVVBfSE9PS1MnO1xuICAvKiogQWRkaXRpb25hbCAuTkVUIGRlcGVuZGVuY2llcyBjb25maWd1cmF0aW9uICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRE9UTkVUX0FERElUSU9OQUxfREVQUyA9ICdET1RORVRfQURESVRJT05BTF9ERVBTJztcblxuICAvKiogLk5FVCBhdXRvLWluc3RydW1lbnRhdGlvbiBob21lIGRpcmVjdG9yeSAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9URUxfRE9UTkVUX0FVVE9fSE9NRSA9ICdPVEVMX0RPVE5FVF9BVVRPX0hPTUUnO1xuXG4gIC8qKiAuTkVUIHNoYXJlZCBzdG9yZSBjb25maWd1cmF0aW9uICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRE9UTkVUX1NIQVJFRF9TVE9SRSA9ICdET1RORVRfU0hBUkVEX1NUT1JFJztcbn1cblxuLyoqXG4gKiBOb2RlLXNwZWNpZmljIE9wZW5UZWxlbWV0cnkgaW5zdHJ1bWVudGF0aW9uIGNvbmZpZ3VyYXRpb25zLlxuICogQ29udGFpbnMgY29uc3RhbnRzIGZvciBOb2RlLmpzIHJ1bnRpbWUgc2V0dGluZ3MgYW5kIG9wdGlvbnMuXG4gKi9cbmV4cG9ydCBjbGFzcyBOb2RlSW5zdHJ1bWVudGF0aW9uIHtcbiAgLyoqIE5vZGUuanMgb3B0aW9ucyBlbnZpcm9ubWVudCB2YXJpYWJsZSAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE5PREVfT1BUSU9OUyA9ICdOT0RFX09QVElPTlMnO1xufVxuIl19