/**
 * Common OpenTelemetry exporter configurations and AWS Application Signals settings.
 * Contains constants for OTLP protocol, resource attributes, and Application Signals enablement.
 */
export declare class CommonExporting {
    /** Protocol configuration for OpenTelemetry OTLP exporter */
    static readonly OTEL_EXPORTER_OTLP_PROTOCOL = "OTEL_EXPORTER_OTLP_PROTOCOL";
    /** HTTP/Protobuf protocol setting for OTLP exporter */
    static readonly OTEL_EXPORTER_OTLP_PROTOCOL_HTTP_PROTOBUF = "http/protobuf";
    /** Resource attribute configuration for service.name */
    static readonly OTEL_SERVICE_NAME = "OTEL_SERVICE_NAME";
    /** Resource attributes configuration for OpenTelemetry */
    static readonly OTEL_RESOURCE_ATTRIBUTES = "OTEL_RESOURCE_ATTRIBUTES";
    /** Flag to enable/disable AWS Application Signals */
    static readonly OTEL_AWS_APPLICATION_SIGNALS = "OTEL_AWS_APPLICATION_SIGNALS_ENABLED";
    /** Value to enable AWS Application Signals */
    static readonly OTEL_AWS_APPLICATION_SIGNALS_ENABLED = "true";
    /** Value to disable AWS Application Signals */
    static readonly OTEL_AWS_APPLICATION_SIGNALS_DISABLED = "false";
    /** Runtime configuration for AWS Application Signals */
    static readonly OTEL_AWS_APPLICATION_SIGNALS_RUNTIME = "OTEL_AWS_APPLICATION_SIGNALS_RUNTIME_ENABLED";
    /** Value to enable AWS Application Signals runtime */
    static readonly OTEL_AWS_APPLICATION_SIGNALS_RUNTIME_ENABLED = "true";
    /** Value to disable AWS Application Signals runtime */
    static readonly OTEL_AWS_APPLICATION_SIGNALS_RUNTIME_DISABLED = "false";
    /** Endpoint configuration for AWS Application Signals exporter */
    static readonly OTEL_AWS_APPLICATION_SIGNALS_EXPORTER_ENDPOINT = "OTEL_AWS_APPLICATION_SIGNALS_EXPORTER_ENDPOINT";
    /** Local CloudWatch Agent endpoint for metrics */
    static readonly OTEL_AWS_APPLICATION_SIGNALS_EXPORTER_ENDPOINT_LOCAL_CWA = "http://localhost:4316/v1/metrics";
}
/**
 * OpenTelemetry logs exporter configurations.
 * Contains constants for configuring log export behavior.
 */
export declare class LogsExporting {
    /** Configuration for OpenTelemetry logs exporter */
    static readonly OTEL_LOGS_EXPORTER = "OTEL_LOGS_EXPORTER";
    /** Disable logs export */
    static readonly OTEL_LOGS_EXPORTER_NONE = "none";
    /** Enable OTLP logs export */
    static readonly OTEL_LOGS_EXPORTER_OTLP = "otlp";
}
/**
 * OpenTelemetry metrics exporter configurations.
 * Contains constants for configuring metrics export behavior.
 */
export declare class MetricsExporting {
    /** Configuration for OpenTelemetry metrics exporter */
    static readonly OTEL_METRICS_EXPORTER = "OTEL_METRICS_EXPORTER";
    /** Disable metrics export */
    static readonly OTEL_METRICS_EXPORTER_NONE = "none";
    /** Enable OTLP metrics export */
    static readonly OTEL_METRICS_EXPORTER_OTLP = "otlp";
}
/**
 * OpenTelemetry trace exporter and sampling configurations.
 * Contains constants for trace endpoints, sampling strategies, and propagation formats.
 */
export declare class TraceExporting {
    /** Endpoint configuration for OTLP traces */
    static readonly OTEL_EXPORTER_OTLP_TRACES_ENDPOINT = "OTEL_EXPORTER_OTLP_TRACES_ENDPOINT";
    /** Local CloudWatch Agent endpoint for traces */
    static readonly OTEL_EXPORTER_OTLP_TRACES_ENDPOINT_LOCAL_CWA = "http://localhost:4316/v1/traces";
    /** Sampling configuration for traces */
    static readonly OTEL_TRACES_SAMPLER = "OTEL_TRACES_SAMPLER";
    /** X-Ray sampling strategy */
    static readonly OTEL_TRACES_SAMPLER_XRAY = "xray";
    /** Trace ID ratio based sampling */
    static readonly OTEL_TRACES_SAMPLER_TRACEID_RATIO = "traceidratio";
    /** Sample all traces */
    static readonly OTEL_TRACES_SAMPLER_ALWAYS_ON = "always_on";
    /** Sample no traces */
    static readonly OTEL_TRACES_SAMPLER_ALWAYS_OFF = "always_off";
    /** Parent-based trace ID ratio sampling */
    static readonly OTEL_TRACES_SAMPLER_PARENT_BASED_TRACEID_RATIO = "parentbased_traceidratio";
    /** Parent-based always on sampling */
    static readonly OTEL_TRACES_SAMPLER_PARENT_BASED_ALWAYS_ON = "parentbased_always_on";
    /** Parent-based always off sampling */
    static readonly OTEL_TRACES_SAMPLER_PARENT_BASED_ALWAYS_OFF = "parentbased_always_off";
    /** Arguments for trace sampler configuration */
    static readonly OTEL_TRACES_SAMPLER_ARG = "OTEL_TRACES_SAMPLER_ARG";
    /** Local CloudWatch Agent endpoint for sampler */
    static readonly OTEL_TRACES_SAMPLER_ARG_LOCAL_CWA = "endpoint=http://localhost:2000";
    /** Configuration for trace context propagation */
    static readonly OTEL_PROPAGATORS = "OTEL_PROPAGATORS";
    /** Supported propagation formats for Application Signals */
    static readonly OTEL_PROPAGATORS_APPLICATION_SIGNALS = "tracecontext,baggage,b3,xray";
}
/**
 * Java-specific OpenTelemetry instrumentation configurations.
 * Contains constants for Java agent setup and tool options.
 */
export declare class JavaInstrumentation {
    /** Java tool options environment variable */
    static readonly JAVA_TOOL_OPTIONS = "JAVA_TOOL_OPTIONS";
}
/**
 * Python-specific OpenTelemetry instrumentation configurations.
 * Contains constants for Python distribution, configurator, and path settings.
 */
export declare class PythonInstrumentation {
    /** Python OpenTelemetry distribution configuration */
    static readonly OTEL_PYTHON_DISTRO = "OTEL_PYTHON_DISTRO";
    /** AWS distribution for Python OpenTelemetry */
    static readonly OTEL_PYTHON_DISTRO_AWS_DISTRO = "aws_distro";
    /** Python OpenTelemetry configurator setting */
    static readonly OTEL_PYTHON_CONFIGURATOR = "OTEL_PYTHON_CONFIGURATOR";
    /** AWS configurator for Python OpenTelemetry */
    static readonly OTEL_PYTHON_CONFIGURATOR_AWS_CONFIGURATOR = "aws_configurator";
    /** Python path environment variable */
    static readonly PYTHONPATH = "PYTHONPATH";
}
/**
 * .NET-specific OpenTelemetry instrumentation configurations.
 * Contains constants for .NET runtime settings, profiler configurations, and paths
 * for both Linux and Windows environments.
 */
export declare class DotnetInstrumentation {
    /** .NET OpenTelemetry distribution configuration */
    static readonly OTEL_DOTNET_DISTRO = "OTEL_DOTNET_DISTRO";
    /** AWS distribution for .NET OpenTelemetry */
    static readonly OTEL_DOTNET_DISTRO_AWS_DISTRO = "aws_distro";
    /** .NET OpenTelemetry configurator setting */
    static readonly OTEL_DOTNET_CONFIGURATOR = "OTEL_DOTNET_CONFIGURATOR";
    /** AWS configurator for .NET OpenTelemetry */
    static readonly OTEL_DOTNET_CONFIGURATOR_AWS_CONFIGURATOR = "aws_configurator";
    /** .NET auto-instrumentation plugins configuration */
    static readonly OTEL_DOTNET_AUTO_PLUGINS = "OTEL_DOTNET_AUTO_PLUGINS";
    /** ADOT auto-instrumentation plugin for .NET */
    static readonly OTEL_DOTNET_AUTO_PLUGINS_ADOT = "AWS.Distro.OpenTelemetry.AutoInstrumentation.Plugin, AWS.Distro.OpenTelemetry.AutoInstrumentation";
    /** CoreCLR profiling enable flag */
    static readonly CORECLR_ENABLE_PROFILING = "CORECLR_ENABLE_PROFILING";
    /** Enable CoreCLR profiling */
    static readonly CORECLR_ENABLE_PROFILING_ENABLED = "1";
    /** Disable CoreCLR profiling */
    static readonly CORECLR_ENABLE_PROFILING_DISABLED = "0";
    /** CoreCLR profiler GUID */
    static readonly CORECLR_PROFILER = "CORECLR_PROFILER";
    /** OpenTelemetry CoreCLR profiler ID */
    static readonly CORECLR_PROFILER_OTEL = "{918728DD-259F-4A6A-AC2B-B85E1B658318}";
    /** Path to CoreCLR profiler */
    static readonly CORECLR_PROFILER_PATH = "CORECLR_PROFILER_PATH";
    /** .NET startup hooks configuration */
    static readonly DOTNET_STARTUP_HOOKS = "DOTNET_STARTUP_HOOKS";
    /** Additional .NET dependencies configuration */
    static readonly DOTNET_ADDITIONAL_DEPS = "DOTNET_ADDITIONAL_DEPS";
    /** .NET auto-instrumentation home directory */
    static readonly OTEL_DOTNET_AUTO_HOME = "OTEL_DOTNET_AUTO_HOME";
    /** .NET shared store configuration */
    static readonly DOTNET_SHARED_STORE = "DOTNET_SHARED_STORE";
}
/**
 * Node-specific OpenTelemetry instrumentation configurations.
 * Contains constants for Node.js runtime settings and options.
 */
export declare class NodeInstrumentation {
    /** Node.js options environment variable */
    static readonly NODE_OPTIONS = "NODE_OPTIONS";
}
