# konectipy
KONECT (the Koblenz Network Collection) is a project to collect large network datasets of all types in order to perform research in network science and related fields, collected by the Institute of Web Science and Technologies at the University of Koblenz–Landau.

KONECT contains several hundred network datasets of various types, including directed, undirected, bipartite, weighted, unweighted, signed and rating networks. The networks of KONECT cover many diverse areas such as social networks, hyperlink networks, authorship networks, physical networks, interaction networks, and communication networks. The KONECT project has developed free software network analysis tools which are used to compute network statistics, to draw plots and to implement various link prediction algorithms. The result of these analyses are presented on these pages. Whenever we are allowed to do so, we provide a download of the networks.

konectipy is a python pacakge to analyse graphs, generated by the networkx library.

  

#  Featured Plots:

  - Degree Distribution
  - Cumulative Degree Distribution
  - Assortativity
  - Lorenz Curve
  - Spectral Plot

## Degree Distribution
The distribution of degree values \(d(u)\) over all vertices \(u\) characterizes the network as a whole, and is often used to visualize a network. In particular, a power law is often assumed, stating that the number of nodes with \(n\) neighbors is proportional to \(n^{-\gamma}\), for a constant \(\gamma\) [1]. This assumption can be inspected visually by plotting the degree distribution on a doubly logarithmic scale, on which a power law renders as a straight line.

The degree distribution shows the number of nodes with degree \(n\), in function of \(n\).

This plot uses a doubly logarithmic scale.

## Cumulative Degree Distribution
The cumulative degree distribution shows the probability that the degree of a node picked at random is larger than \(n\), in function of \(n\).
## Assortativity
In some networks, nodes with high degree are more often connected with other nodes of high degree, while nodes of low degree are more often connected with other nodes of low degree. This property is called assortativity, i.e., such networks are said to be assortativity. On the other hand, some networks, are dissortative, i.e., in them nodes of high degree are more often connected to nodes of low degree and vice versa. In addition to the assortativity \(\rho\) defined as the Pearson correlation coefficient between the degrees of connected nodes, the assortativity or dissortativity of networks may be analyse by plotting all nodes of a network by their degree and the average degree of their neighbors. Thus, the assortativity plot of a network shows all nodes of a network with the degree on the X axis, and the average degree of their neighbors on the Y axis.
## Lorenz Curve
The Lorenz curve is a tool originally from economics that visualizes statements of the form “X% of nodes with smallest degree account for Y% of edges”. The set of values \((X,Y)\) thus defined is the Lorenz curve. In a network the Lorenz curve is a straight diagonal line when all nodes have the same degree, and curved otherwise [1]. The area between the Lorenz curve and the diagonal is half the Gini coefficient.
## Spectral Plot
The spectral distribution refers to the distribution of the eigenvalues of a characteristic matrix of the network. In KONECT, we show the eigenvalues of the adjacency matrix A, of the normalized adjacency matrix N = D−1/2 A D−1/2, and of the Laplacian matrix L = D − A.

All matrices are of size |V| × |V|, where |V| is the number of nodes in the graph.

The adjacency matrix A contains the edge weights of all edges, or 1 for unweighted networks. A contains 0 for all nodes pairs that are unconnected. For networks with multiple edges, A contains the number of edges connecting any two nodes. The matrix A has both positive and negative eigenvalues in the general case.

The matrix D is the degree matrix of the graph. It is diagonal, and contains the degree of the nodes on the diagonal entries. For weighted networks, the entries are the sum of absolute values of adjacent edge weights.

The matrix N = D−1/2 A D−1/2 is the normalized adjacency matrix. Its eigenvalues are restricted to the range [−1, +1].

The Laplacian matrix L = D − A has only nonnegative eigenvalues, i.e., it is positive-semidefinite.

Note that the bars representing the number of eigenvalues equal to zero is cut off in most plots, since the number of such eigenvalues is usually very high.

### Installation

konectipy requires Python >=3.6 to run.

To install

```sh
$ pip install konectipy
```

#### Sample Code
Using the package is as simple as that. All you need is a networkx graph object stored as a .gexf file.

```py
import konectipy.konectipy as kpy

plot = kpy.plot()

# enter the .gexf file with the correct path

plot.degree_distribution('file_path.gexf') 
plot.cumulative_dd('file_path.gexf')
plot.assortativity('file_path.gexf')
plot.lorenz_curve('file_path.gexf')
plot.spectral_plot('file_path.gexf')
```

### Development

Want to contribute? Great!
Fork in in github https://github.com/AkiMosi/konectipy

### Todos

 - To make it more general
 - To make documentations

License
----

MIT


