"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_ec2_1 = require("monocdk/aws-ec2");
const nag_pack_1 = require("../../nag-pack");
/**
 * Subnets do not auto-assign public IP addresses
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_ec2_1.CfnSubnet) {
        const mapPublicIpOnLaunch = nag_pack_1.resolveIfPrimitive(node, node.mapPublicIpOnLaunch);
        const assignIpv6AddressOnCreation = nag_pack_1.resolveIfPrimitive(node, node.assignIpv6AddressOnCreation);
        if (mapPublicIpOnLaunch === true ||
            assignIpv6AddressOnCreation === true) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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