"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_secretsmanager_1 = require("monocdk/aws-secretsmanager");
const nag_pack_1 = require("../../nag-pack");
/**
 * Secrets are encrypted with KMS Customer managed keys
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_secretsmanager_1.CfnSecret) {
        const kmsKeyId = nag_pack_1.resolveIfPrimitive(node, node.kmsKeyId);
        if (kmsKeyId === undefined || kmsKeyId === 'aws/secretsmanager') {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU2VjcmV0c01hbmFnZXJVc2luZ0tNU0tleS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9ydWxlcy9zZWNyZXRzbWFuYWdlci9TZWNyZXRzTWFuYWdlclVzaW5nS01TS2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YsK0JBQTZCO0FBQzdCLG1FQUF1RDtBQUV2RCw2Q0FBb0Q7QUFFcEQ7OztHQUdHO0FBQ0gsa0JBQWUsTUFBTSxDQUFDLGNBQWMsQ0FDbEMsQ0FBQyxJQUFpQixFQUFXLEVBQUU7SUFDN0IsSUFBSSxJQUFJLFlBQVksOEJBQVMsRUFBRTtRQUM3QixNQUFNLFFBQVEsR0FBRyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3pELElBQUksUUFBUSxLQUFLLFNBQVMsSUFBSSxRQUFRLEtBQUssb0JBQW9CLEVBQUU7WUFDL0QsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDLEVBQ0QsTUFBTSxFQUNOLEVBQUUsS0FBSyxFQUFFLFlBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FDbEMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgcGFyc2UgfSBmcm9tICdwYXRoJztcbmltcG9ydCB7IENmblNlY3JldCB9IGZyb20gJ21vbm9jZGsvYXdzLXNlY3JldHNtYW5hZ2VyJztcbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi9uYWctcGFjayc7XG5cbi8qKlxuICogU2VjcmV0cyBhcmUgZW5jcnlwdGVkIHdpdGggS01TIEN1c3RvbWVyIG1hbmFnZWQga2V5c1xuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IE9iamVjdC5kZWZpbmVQcm9wZXJ0eShcbiAgKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiA9PiB7XG4gICAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5TZWNyZXQpIHtcbiAgICAgIGNvbnN0IGttc0tleUlkID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUua21zS2V5SWQpO1xuICAgICAgaWYgKGttc0tleUlkID09PSB1bmRlZmluZWQgfHwga21zS2V5SWQgPT09ICdhd3Mvc2VjcmV0c21hbmFnZXInKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIHRydWU7XG4gIH0sXG4gICduYW1lJyxcbiAgeyB2YWx1ZTogcGFyc2UoX19maWxlbmFtZSkubmFtZSB9XG4pO1xuIl19