"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_s3_1 = require("monocdk/aws-s3");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * S3 Buckets prohibit public read access through their Block Public Access configurations and bucket ACLs
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_s3_1.CfnBucket) {
        const publicAccessBlockConfiguration = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        if (publicAccessBlockConfiguration === undefined ||
            nag_pack_1.resolveIfPrimitive(node, publicAccessBlockConfiguration.blockPublicPolicy) !== true) {
            return false;
        }
        const accessControl = nag_pack_1.resolveIfPrimitive(node, node.accessControl);
        const blockPublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccessBlockConfiguration.blockPublicAcls);
        if ((accessControl === 'PublicRead' ||
            accessControl === 'PublicReadWrite') &&
            blockPublicAcls !== true) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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