"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_s3_1 = require("monocdk/aws-s3");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * S3 Buckets prohibit public access through bucket level settings
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_s3_1.CfnBucket) {
        if (node.publicAccessBlockConfiguration == undefined) {
            return false;
        }
        const publicAccess = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        const blockPublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccess.blockPublicAcls);
        const blockPublicPolicy = nag_pack_1.resolveIfPrimitive(node, publicAccess.blockPublicPolicy);
        const ignorePublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccess.ignorePublicAcls);
        const restrictPublicBuckets = nag_pack_1.resolveIfPrimitive(node, publicAccess.restrictPublicBuckets);
        if (blockPublicAcls !== true ||
            blockPublicPolicy !== true ||
            ignorePublicAcls !== true ||
            restrictPublicBuckets !== true) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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