"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_redshift_1 = require("monocdk/aws-redshift");
const nag_pack_1 = require("../../nag-pack");
/**
 * Redshift clusters have version upgrades enabled, automated snapshot retention periods enabled, and explicit maintenance windows configured
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_redshift_1.CfnCluster) {
        const allowVersionUpgrade = nag_pack_1.resolveIfPrimitive(node, node.allowVersionUpgrade);
        const automatedSnapshotRetentionPeriod = nag_pack_1.resolveIfPrimitive(node, node.automatedSnapshotRetentionPeriod);
        if ((automatedSnapshotRetentionPeriod != undefined &&
            automatedSnapshotRetentionPeriod == 0) ||
            node.preferredMaintenanceWindow == undefined ||
            allowVersionUpgrade === false) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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