"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_rds_1 = require("monocdk/aws-rds");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * RDS DB instances are configured to export all possible log types to CloudWatch
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const dbType = JSON.stringify(nag_pack_1.resolveIfPrimitive(node, node.engine));
        const dbLogs = JSON.stringify(monocdk_1.Stack.of(node).resolve(node.enableCloudwatchLogsExports));
        if (dbLogs == undefined) {
            return false;
        }
        if (dbType.includes('mariadb') || dbType.includes('mysql')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('error') &&
                dbLogs.includes('general') &&
                dbLogs.includes('slowquery')))
                return false;
        }
        if (dbType.includes('postgres')) {
            if (!(dbLogs.includes('postgresql') && dbLogs.includes('upgrade')))
                return false;
        }
        if (dbType.includes('oracle')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('alert') &&
                dbLogs.includes('listener') &&
                dbLogs.includes('oemagent') &&
                dbLogs.includes('trace')))
                return false;
        }
        if (dbType.includes('sqlserver')) {
            if (!(dbLogs.includes('agent') && dbLogs.includes('error')))
                return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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