"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
const aws_opensearchservice_1 = require("monocdk/aws-opensearchservice");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * OpenSearch Service domains are node-to-node encrypted
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticsearch_1.CfnDomain || node instanceof aws_opensearchservice_1.CfnDomain) {
        const encryptedNodeToNode = monocdk_1.Stack.of(node).resolve(node.nodeToNodeEncryptionOptions);
        if (encryptedNodeToNode != undefined) {
            const enabled = nag_pack_1.resolveIfPrimitive(node, encryptedNodeToNode.enabled);
            if (enabled !== true) {
                return false;
            }
        }
        else {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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