"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
const aws_opensearchservice_1 = require("monocdk/aws-opensearchservice");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * OpenSearch Service domains use dedicated master nodes
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        const elasticsearchClusterConfig = monocdk_1.Stack.of(node).resolve(node.elasticsearchClusterConfig);
        if (elasticsearchClusterConfig == undefined) {
            return false;
        }
        const dedicatedMasterEnabled = nag_pack_1.resolveIfPrimitive(node, elasticsearchClusterConfig.dedicatedMasterEnabled);
        if (!dedicatedMasterEnabled) {
            return false;
        }
    }
    else if (node instanceof aws_opensearchservice_1.CfnDomain) {
        const clusterConfig = monocdk_1.Stack.of(node).resolve(node.clusterConfig);
        if (clusterConfig == undefined) {
            return false;
        }
        const dedicatedMasterEnabled = nag_pack_1.resolveIfPrimitive(node, clusterConfig.dedicatedMasterEnabled);
        if (!dedicatedMasterEnabled) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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