"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_msk_1 = require("monocdk/aws-msk");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * MSK clusters send broker logs to a supported destination
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_msk_1.CfnCluster) {
        const loggingInfo = monocdk_1.Stack.of(node).resolve(node.loggingInfo);
        if (loggingInfo == undefined) {
            return false;
        }
        const resolvedBrokerLogs = monocdk_1.Stack.of(node).resolve(loggingInfo.brokerLogs);
        let enabled = false;
        const s3 = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.s3);
        if (s3 != undefined) {
            const s3Enabled = nag_pack_1.resolveIfPrimitive(node, s3.enabled);
            if (s3Enabled) {
                enabled = true;
            }
        }
        const cloudWatchLogs = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.cloudWatchLogs);
        if (cloudWatchLogs != undefined) {
            const cloudWatchLogsEnabled = nag_pack_1.resolveIfPrimitive(node, cloudWatchLogs.enabled);
            if (cloudWatchLogsEnabled) {
                enabled = true;
            }
        }
        const firehose = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.firehose);
        if (firehose != undefined) {
            const firehoseEnabled = nag_pack_1.resolveIfPrimitive(node, firehose.enabled);
            if (firehoseEnabled) {
                enabled = true;
            }
        }
        if (!enabled) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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