"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_kinesis_1 = require("monocdk/aws-kinesis");
const monocdk_1 = require("monocdk");
/**
 * Kinesis Data Streams use the "aws/kinesis" key when server-sided encryption is enabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_kinesis_1.CfnStream) {
        const streamEncryption = monocdk_1.Stack.of(node).resolve(node.streamEncryption);
        if (streamEncryption !== undefined) {
            if (streamEncryption.keyId !== 'alias/aws/kinesis') {
                return false;
            }
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiS2luZXNpc0RhdGFTdHJlYW1EZWZhdWx0S2V5V2hlblNTRS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9ydWxlcy9raW5lc2lzL0tpbmVzaXNEYXRhU3RyZWFtRGVmYXVsdEtleVdoZW5TU0UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRiwrQkFBNkI7QUFDN0IscURBQWdEO0FBQ2hELHFDQUE2QztBQUU3Qzs7O0dBR0c7QUFDSCxrQkFBZSxNQUFNLENBQUMsY0FBYyxDQUNsQyxDQUFDLElBQWlCLEVBQVcsRUFBRTtJQUM3QixJQUFJLElBQUksWUFBWSx1QkFBUyxFQUFFO1FBQzdCLE1BQU0sZ0JBQWdCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDdkUsSUFBSSxnQkFBZ0IsS0FBSyxTQUFTLEVBQUU7WUFDbEMsSUFBSSxnQkFBZ0IsQ0FBQyxLQUFLLEtBQUssbUJBQW1CLEVBQUU7Z0JBQ2xELE9BQU8sS0FBSyxDQUFDO2FBQ2Q7U0FDRjtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDLEVBQ0QsTUFBTSxFQUNOLEVBQUUsS0FBSyxFQUFFLFlBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FDbEMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgcGFyc2UgfSBmcm9tICdwYXRoJztcbmltcG9ydCB7IENmblN0cmVhbSB9IGZyb20gJ21vbm9jZGsvYXdzLWtpbmVzaXMnO1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5cbi8qKlxuICogS2luZXNpcyBEYXRhIFN0cmVhbXMgdXNlIHRoZSBcImF3cy9raW5lc2lzXCIga2V5IHdoZW4gc2VydmVyLXNpZGVkIGVuY3J5cHRpb24gaXMgZW5hYmxlZFxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IE9iamVjdC5kZWZpbmVQcm9wZXJ0eShcbiAgKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiA9PiB7XG4gICAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5TdHJlYW0pIHtcbiAgICAgIGNvbnN0IHN0cmVhbUVuY3J5cHRpb24gPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUuc3RyZWFtRW5jcnlwdGlvbik7XG4gICAgICBpZiAoc3RyZWFtRW5jcnlwdGlvbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgIGlmIChzdHJlYW1FbmNyeXB0aW9uLmtleUlkICE9PSAnYWxpYXMvYXdzL2tpbmVzaXMnKSB7XG4gICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICAgIHJldHVybiB0cnVlO1xuICB9LFxuICAnbmFtZScsXG4gIHsgdmFsdWU6IHBhcnNlKF9fZmlsZW5hbWUpLm5hbWUgfVxuKTtcbiJdfQ==