"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_kinesisanalytics_1 = require("monocdk/aws-kinesisanalytics");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * Kinesis Data Analytics Flink Applications have checkpointing enabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_kinesisanalytics_1.CfnApplicationV2) {
        if (node.runtimeEnvironment.toLowerCase().startsWith('flink')) {
            const applicationConfiguration = monocdk_1.Stack.of(node).resolve(node.applicationConfiguration);
            if (applicationConfiguration == undefined) {
                return false;
            }
            const flinkApplicationConfiguration = monocdk_1.Stack.of(node).resolve(applicationConfiguration.flinkApplicationConfiguration);
            if (flinkApplicationConfiguration == undefined) {
                return false;
            }
            const checkpointConfiguration = monocdk_1.Stack.of(node).resolve(flinkApplicationConfiguration.checkpointConfiguration);
            if (checkpointConfiguration == undefined) {
                return false;
            }
            if (nag_pack_1.resolveIfPrimitive(node, checkpointConfiguration.configurationType) ==
                'CUSTOM') {
                const enabled = nag_pack_1.resolveIfPrimitive(node, checkpointConfiguration.checkpointingEnabled);
                if (!enabled) {
                    return false;
                }
            }
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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