"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_iam_1 = require("monocdk/aws-iam");
const monocdk_1 = require("monocdk");
/**
 * IAM entities with wildcard permissions have a cdk_nag rule suppression with evidence for those permission
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_iam_1.CfnGroup ||
        node instanceof aws_iam_1.CfnUser ||
        node instanceof aws_iam_1.CfnRole) {
        const inlinePolicies = monocdk_1.Stack.of(node).resolve(node.policies);
        if (inlinePolicies != undefined) {
            for (const policy of inlinePolicies) {
                const resolvedPolicy = monocdk_1.Stack.of(node).resolve(policy);
                const resolvedPolicyDocument = monocdk_1.Stack.of(node).resolve(resolvedPolicy.policyDocument);
                if (JSON.stringify(resolvedPolicyDocument).includes('*')) {
                    return false;
                }
            }
        }
    }
    else if (node instanceof aws_iam_1.CfnPolicy || node instanceof aws_iam_1.CfnManagedPolicy) {
        const policyDocument = monocdk_1.Stack.of(node).resolve(node.policyDocument);
        if (JSON.stringify(policyDocument).includes('*')) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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