"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticloadbalancing_1 = require("monocdk/aws-elasticloadbalancing");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * CLB listeners are configured for secure (HTTPs or SSL) protocols for client communication
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticloadbalancing_1.CfnLoadBalancer) {
        const listeners = monocdk_1.Stack.of(node).resolve(node.listeners);
        for (const listener of listeners) {
            const resolvedListener = monocdk_1.Stack.of(node).resolve(listener);
            const protocol = nag_pack_1.resolveIfPrimitive(node, resolvedListener.protocol);
            const instanceProtocol = nag_pack_1.resolveIfPrimitive(node, resolvedListener.instanceProtocol);
            if (protocol.toLowerCase() == 'ssl') {
                if (!(instanceProtocol == undefined ||
                    instanceProtocol.toLowerCase() == 'ssl')) {
                    return false;
                }
            }
            else if (protocol.toLowerCase() == 'https') {
                if (!(instanceProtocol == undefined ||
                    instanceProtocol.toLowerCase() == 'https')) {
                    return false;
                }
            }
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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