"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
const monocdk_1 = require("monocdk");
/**
 * ALBs, NLBs, and GLBs have deletion protection enabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
        if (attributes != undefined) {
            var deletionProtectionEnabled = false;
            for (const attr of attributes) {
                const resolvedAttr = monocdk_1.Stack.of(node).resolve(attr);
                if (resolvedAttr.key != undefined &&
                    resolvedAttr.key == 'deletion_protection.enabled') {
                    if (resolvedAttr.value == 'true') {
                        deletionProtectionEnabled = true;
                    }
                }
            }
            if (!deletionProtectionEnabled) {
                return false;
            }
        }
        else {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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