"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * Application Load Balancers are enabled to drop invalid headers
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const type = nag_pack_1.resolveIfPrimitive(node, node.type);
        if (type == undefined || type == 'application') {
            const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
            if (attributes != undefined) {
                const reg = /"routing\.http\.drop_invalid_header_fields\.enabled","value":"true"/gm;
                if (JSON.stringify(attributes).search(reg) == -1) {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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